/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import no.finn.unleash.EvaluatedToggle;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.MoreOperations;
import no.finn.unleash.Unleash;
import no.finn.unleash.UnleashContext;
import no.finn.unleash.UnleashContextProvider;
import no.finn.unleash.Variant;
import no.finn.unleash.event.EventDispatcher;
import no.finn.unleash.event.ToggleEvaluated;
import no.finn.unleash.lang.Nullable;
import no.finn.unleash.metric.UnleashMetricService;
import no.finn.unleash.metric.UnleashMetricServiceImpl;
import no.finn.unleash.repository.FeatureToggleRepository;
import no.finn.unleash.repository.HttpToggleFetcher;
import no.finn.unleash.repository.ToggleBackupHandlerFile;
import no.finn.unleash.repository.ToggleRepository;
import no.finn.unleash.strategy.ApplicationHostnameStrategy;
import no.finn.unleash.strategy.DefaultStrategy;
import no.finn.unleash.strategy.FlexibleRolloutStrategy;
import no.finn.unleash.strategy.GradualRolloutRandomStrategy;
import no.finn.unleash.strategy.GradualRolloutSessionIdStrategy;
import no.finn.unleash.strategy.GradualRolloutUserIdStrategy;
import no.finn.unleash.strategy.RemoteAddressStrategy;
import no.finn.unleash.strategy.Strategy;
import no.finn.unleash.strategy.UnknownStrategy;
import no.finn.unleash.strategy.UserWithIdStrategy;
import no.finn.unleash.util.UnleashConfig;
import no.finn.unleash.variant.VariantUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultUnleash
implements Unleash {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUnleash.class);
    private static final List<Strategy> BUILTIN_STRATEGIES = Arrays.asList(new DefaultStrategy(), new ApplicationHostnameStrategy(), new GradualRolloutRandomStrategy(), new GradualRolloutSessionIdStrategy(), new GradualRolloutUserIdStrategy(), new RemoteAddressStrategy(), new UserWithIdStrategy(), new FlexibleRolloutStrategy());
    public static final UnknownStrategy UNKNOWN_STRATEGY = new UnknownStrategy();
    private final UnleashMetricService metricService;
    private final ToggleRepository toggleRepository;
    private final Map<String, Strategy> strategyMap;
    private final UnleashContextProvider contextProvider;
    private final EventDispatcher eventDispatcher;
    private final UnleashConfig config;

    private static FeatureToggleRepository defaultToggleRepository(UnleashConfig unleashConfig) {
        return new FeatureToggleRepository(unleashConfig, new HttpToggleFetcher(unleashConfig), new ToggleBackupHandlerFile(unleashConfig));
    }

    public DefaultUnleash(UnleashConfig unleashConfig, Strategy ... strategies) {
        this(unleashConfig, (ToggleRepository)DefaultUnleash.defaultToggleRepository(unleashConfig), strategies);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, ToggleRepository toggleRepository, Strategy ... strategies) {
        this(unleashConfig, toggleRepository, DefaultUnleash.buildStrategyMap(strategies), unleashConfig.getContextProvider(), new EventDispatcher(unleashConfig), new UnleashMetricServiceImpl(unleashConfig, unleashConfig.getScheduledExecutor()));
    }

    public DefaultUnleash(UnleashConfig unleashConfig, ToggleRepository toggleRepository, Map<String, Strategy> strategyMap, UnleashContextProvider contextProvider, EventDispatcher eventDispatcher, UnleashMetricService metricService) {
        this.config = unleashConfig;
        this.toggleRepository = toggleRepository;
        this.strategyMap = strategyMap;
        this.contextProvider = contextProvider;
        this.eventDispatcher = eventDispatcher;
        this.metricService = metricService;
        metricService.register(strategyMap.keySet());
    }

    @Override
    public boolean isEnabled(String toggleName) {
        return this.isEnabled(toggleName, false);
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, boolean defaultSetting) {
        return this.isEnabled(toggleName, context, (n, c) -> defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        boolean enabled = this.checkEnabled(toggleName, context, fallbackAction);
        this.count(toggleName, enabled);
        this.eventDispatcher.dispatch(new ToggleEvaluated(toggleName, enabled));
        return enabled;
    }

    private boolean checkEnabled(String toggleName, UnleashContext context, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        boolean enabled;
        this.checkIfToggleMatchesNamePrefix(toggleName);
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        if (featureToggle == null) {
            enabled = fallbackAction.apply(toggleName, enhancedContext);
        } else if (!featureToggle.isEnabled()) {
            enabled = false;
        } else {
            if (featureToggle.getStrategies().size() == 0) {
                return true;
            }
            enabled = featureToggle.getStrategies().stream().anyMatch(strategy -> {
                Strategy configuredStrategy = this.getStrategy(strategy.getName());
                if (configuredStrategy == UNKNOWN_STRATEGY) {
                    LOGGER.warn("Unable to find matching strategy for toggle:{} strategy:{}", (Object)toggleName, (Object)strategy.getName());
                }
                return configuredStrategy.isEnabled(strategy.getParameters(), enhancedContext, strategy.getConstraints());
            });
        }
        return enabled;
    }

    private void checkIfToggleMatchesNamePrefix(String toggleName) {
        if (this.config.getNamePrefix() != null && !toggleName.startsWith(this.config.getNamePrefix())) {
            LOGGER.warn("Toggle [{}] doesnt start with configured name prefix of [{}] so it will always be disabled", (Object)toggleName, (Object)this.config.getNamePrefix());
        }
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        boolean enabled = this.checkEnabled(toggleName, context, (n, c) -> false);
        Variant variant = enabled ? VariantUtil.selectVariant(featureToggle, context, defaultValue) : defaultValue;
        this.metricService.countVariant(toggleName, variant.getName());
        return variant;
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, this.contextProvider.getContext());
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        return this.getVariant(toggleName, this.contextProvider.getContext(), defaultValue);
    }

    public Optional<FeatureToggle> getFeatureToggleDefinition(String toggleName) {
        return Optional.ofNullable(this.toggleRepository.getToggle(toggleName));
    }

    @Override
    @Deprecated
    public List<String> getFeatureToggleNames() {
        return this.toggleRepository.getFeatureNames();
    }

    @Deprecated
    public void count(String toggleName, boolean enabled) {
        this.metricService.count(toggleName, enabled);
    }

    private static Map<String, Strategy> buildStrategyMap(@Nullable Strategy[] strategies) {
        HashMap<String, Strategy> map = new HashMap<String, Strategy>();
        BUILTIN_STRATEGIES.forEach(strategy -> map.put(strategy.getName(), (Strategy)strategy));
        if (strategies != null) {
            for (Strategy strategy2 : strategies) {
                map.put(strategy2.getName(), strategy2);
            }
        }
        return map;
    }

    private Strategy getStrategy(String strategy) {
        return this.strategyMap.getOrDefault(strategy, this.config.getFallbackStrategy());
    }

    @Override
    public void shutdown() {
        this.config.getScheduledExecutor().shutdown();
    }

    @Override
    public MoreOperations more() {
        return new DefaultMore();
    }

    public class DefaultMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return DefaultUnleash.this.toggleRepository.getFeatureNames();
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(DefaultUnleash.this.contextProvider.getContext());
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(UnleashContext context) {
            return this.getFeatureToggleNames().stream().map(toggleName -> {
                boolean enabled = DefaultUnleash.this.checkEnabled(toggleName, context, (n, c) -> false);
                FeatureToggle featureToggle = DefaultUnleash.this.toggleRepository.getToggle((String)toggleName);
                Variant variant = enabled ? VariantUtil.selectVariant(featureToggle, context, Variant.DISABLED_VARIANT) : Variant.DISABLED_VARIANT;
                return new EvaluatedToggle((String)toggleName, enabled, variant);
            }).collect(Collectors.toList());
        }

        @Override
        public void count(String toggleName, boolean enabled) {
            DefaultUnleash.this.metricService.count(toggleName, enabled);
        }

        @Override
        public void countVariant(String toggleName, String variantName) {
            DefaultUnleash.this.metricService.countVariant(toggleName, variantName);
        }
    }
}

