/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.aspect;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.ChaosMonkeyBaseAspect;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;

@Aspect
public class SpringBootHealthIndicatorAspect
extends ChaosMonkeyBaseAspect {
    private static final Logger log = LoggerFactory.getLogger(SpringBootHealthIndicatorAspect.class);
    private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
    private final WatcherProperties watcherProperties;

    @Pointcut(value="execution(* org.springframework.boot.actuate.health.HealthIndicator.getHealth(..))")
    public void getHealthPointCut() {
    }

    @Around(value="getHealthPointCut() && !classInChaosMonkeyPackage()")
    public Object intercept(ProceedingJoinPoint pjp) throws Throwable {
        Health health = (Health)pjp.proceed();
        if (this.watcherProperties.isActuatorHealth()) {
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            try {
                this.chaosMonkeyRequestScope.callChaosMonkey(ChaosTarget.ACTUATOR_HEALTH, this.createSignature(signature));
            }
            catch (Exception e) {
                log.error("Exception occurred", e);
                health = Health.down((Exception)e).build();
            }
        }
        return health;
    }

    public SpringBootHealthIndicatorAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope, WatcherProperties watcherProperties) {
        this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
        this.watcherProperties = watcherProperties;
    }
}

