/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.SizeConverter;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class MemoryAssault
implements ChaosMonkeyRuntimeAssault {
    private static final Logger Logger = LoggerFactory.getLogger(MemoryAssault.class);
    private static final AtomicLong stolenMemory = new AtomicLong(0L);
    private final Runtime runtime;
    private final AtomicBoolean inAttack = new AtomicBoolean(false);
    private final ChaosMonkeySettings settings;
    private final MetricEventPublisher metricEventPublisher;

    public MemoryAssault(Runtime runtime, ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this.runtime = runtime;
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isMemoryActive();
    }

    @Override
    @Async
    public void attack() {
        Logger.info("Chaos Monkey - memory assault");
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(MetricType.MEMORY_ASSAULT, new String[0]);
        }
        if (this.inAttack.compareAndSet(false, true)) {
            try {
                Logger.debug("Detected java version: " + System.getProperty("java.version"));
                this.eatFreeMemory();
            }
            finally {
                this.inAttack.set(false);
            }
        }
        Logger.info("Chaos Monkey - memory assault cleaned up");
    }

    private void eatFreeMemory() {
        Vector<byte[]> memoryVector = new Vector<byte[]>();
        long stolenMemoryTotal = 0L;
        while (this.isActive()) {
            long freeMemory = this.runtime.freeMemory();
            long usedMemory = this.runtime.totalMemory() - freeMemory;
            if (this.cannotAllocateMoreMemory()) {
                Logger.debug("Cannot allocate more memory");
                break;
            }
            Logger.debug("Used memory in bytes: " + usedMemory);
            stolenMemoryTotal = this.stealMemory(memoryVector, stolenMemoryTotal, this.getBytesToSteal());
            this.waitUntil(this.settings.getAssaultProperties().getMemoryMillisecondsWaitNextIncrease());
        }
        if (this.isActive()) {
            Logger.info("Memory fill reached, now sleeping and holding memory");
            this.waitUntil(this.settings.getAssaultProperties().getMemoryMillisecondsHoldFilledMemory());
        }
        memoryVector.clear();
        this.runtime.gc();
        long stolenAfterComplete = stolenMemory.addAndGet(-stolenMemoryTotal);
        this.metricEventPublisher.publishMetricEvent(MetricType.MEMORY_ASSAULT_MEMORY_STOLEN, stolenAfterComplete);
    }

    private boolean cannotAllocateMoreMemory() {
        double limit = (double)this.runtime.maxMemory() * this.settings.getAssaultProperties().getMemoryFillTargetFraction();
        return (double)this.runtime.totalMemory() > Math.floor(limit);
    }

    private int getBytesToSteal() {
        int amount = (int)((double)this.runtime.freeMemory() * this.settings.getAssaultProperties().getMemoryFillIncrementFraction());
        boolean isJava8 = System.getProperty("java.version").startsWith("1.8");
        return isJava8 ? Math.min(SizeConverter.toBytes(256), amount) : amount;
    }

    private long stealMemory(Vector<byte[]> memoryVector, long stolenMemoryTotal, int bytesToSteal) {
        memoryVector.add(this.createDirtyMemorySlice(bytesToSteal));
        long newStolenTotal = stolenMemory.addAndGet(bytesToSteal);
        this.metricEventPublisher.publishMetricEvent(MetricType.MEMORY_ASSAULT_MEMORY_STOLEN, newStolenTotal);
        Logger.debug("Chaos Monkey - memory assault increase, free memory: " + SizeConverter.toMegabytes(this.runtime.freeMemory()));
        return stolenMemoryTotal += (long)bytesToSteal;
    }

    private byte[] createDirtyMemorySlice(int size) {
        byte[] b = new byte[size];
        for (int idx = 0; idx < size; idx += 4096) {
            b[idx] = 19;
        }
        return b;
    }

    private void waitUntil(int ms) {
        long startNano;
        long now = startNano = System.nanoTime();
        while (startNano + TimeUnit.MILLISECONDS.toNanos(ms) > now && this.isActive()) {
            try {
                long elapsed = TimeUnit.NANOSECONDS.toMillis(startNano - now);
                Thread.sleep(Math.min(100L, (long)ms - elapsed));
                now = System.nanoTime();
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

