/*
 * Decompiled with CFR 0.152.
 */
package com.example.chaos.monkey.chaosdemo.controller;

import com.example.chaos.monkey.chaosdemo.service.GreetingService;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class HelloController {
    private final GreetingService greetingService;

    public HelloController(GreetingService greetingService) {
        this.greetingService = greetingService;
    }

    @GetMapping(value={"/hello"})
    public ResponseEntity<String> sayHello() {
        return ResponseEntity.ok((Object)this.sayHelloPlease());
    }

    @GetMapping(value={"/greet"})
    public ResponseEntity<String> greet() {
        return ResponseEntity.ok((Object)this.greetingService.greet());
    }

    @GetMapping(value={"/dbgreet"})
    public ResponseEntity<String> greetFromDb() {
        return ResponseEntity.ok((Object)this.greetingService.greetFromRepo());
    }

    @GetMapping(value={"/findbyid"})
    public ResponseEntity<String> greetFromDbById() {
        return ResponseEntity.ok((Object)this.greetingService.greetFromRepoPagingSorting());
    }

    @GetMapping(value={"/jpa/findbyid"})
    public ResponseEntity<String> greetFromDbByIdJpa() {
        return ResponseEntity.ok((Object)this.greetingService.greetFromRepoJpa());
    }

    @GetMapping(value={"/common/findbyid"})
    public ResponseEntity<String> greetFromDbByIdAnnotation() {
        return ResponseEntity.ok((Object)this.greetingService.greetFromRepoAnnotation());
    }

    @GetMapping(value={"/goodbye"})
    public ResponseEntity<String> sayGoodbye() {
        return ResponseEntity.ok((Object)"Goodbye!");
    }

    private String sayHelloPlease() {
        return "Hello!";
    }
}

