/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.example.chaos.monkey.chaosdemo.controller;

import com.example.chaos.monkey.chaosdemo.service.GreetingService;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @author Benjamin Wilms
 */
@Controller
public class HelloController {

    private final GreetingService greetingService;

    public HelloController(GreetingService greetingService) {
        this.greetingService = greetingService;
    }

    @GetMapping("/hello")
    public ResponseEntity<String> sayHello() {
        return ResponseEntity.ok(sayHelloPlease());
    }


    @GetMapping("/greet")
    public ResponseEntity<String> greet() {
        return ResponseEntity.ok(greetingService.greet());
    }

    @GetMapping("/dbgreet")
    public ResponseEntity<String> greetFromDb() {
        return ResponseEntity.ok(greetingService.greetFromRepo());
    }

    @GetMapping("/findbyid")
    public ResponseEntity<String> greetFromDbById() {
        return ResponseEntity.ok(greetingService.greetFromRepoPagingSorting());
    }

    @GetMapping("/jpa/findbyid")
    public ResponseEntity<String> greetFromDbByIdJpa() {
        return ResponseEntity.ok(greetingService.greetFromRepoJpa());
    }

    @GetMapping("/common/findbyid")
    public ResponseEntity<String> greetFromDbByIdAnnotation() {
        return ResponseEntity.ok(greetingService.greetFromRepoAnnotation());
    }

    @GetMapping("/goodbye")
    public ResponseEntity<String> sayGoodbye() {
        return ResponseEntity.ok("Goodbye!");
    }

    private String sayHelloPlease() {
        return "Hello!";
    }


}
