/*
 * Decompiled with CFR 0.152.
 */
package com.example.chaos.monkey.chaosdemo.service;

import com.example.chaos.monkey.chaosdemo.repo.Hello;
import com.example.chaos.monkey.chaosdemo.repo.HelloRepo;
import com.example.chaos.monkey.chaosdemo.repo.HelloRepoAnnotation;
import com.example.chaos.monkey.chaosdemo.repo.HelloRepoJpa;
import com.example.chaos.monkey.chaosdemo.repo.HelloRepoSearchAndSorting;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class GreetingService {
    private final HelloRepo helloRepo;
    private final HelloRepoSearchAndSorting repoSearchAndSorting;
    private final HelloRepoJpa helloRepoJpa;
    private final HelloRepoAnnotation helloRepoAnnotation;

    public GreetingService(HelloRepo helloRepo, HelloRepoSearchAndSorting repoSearchAndSorting, HelloRepoJpa helloRepoJpa, HelloRepoAnnotation helloRepoAnnotation) {
        this.helloRepo = helloRepo;
        this.repoSearchAndSorting = repoSearchAndSorting;
        this.helloRepoJpa = helloRepoJpa;
        this.helloRepoAnnotation = helloRepoAnnotation;
    }

    public String greet() {
        return "Greetings from the server side!";
    }

    public String greetFromRepo() {
        Hello databaseSide = (Hello)this.helloRepo.save((Object)new Hello(0L, "Greetings from the database side"));
        return databaseSide.getMessage();
    }

    public String greetFromRepoPagingSorting() {
        Hello databaseSide = (Hello)this.repoSearchAndSorting.save((Object)new Hello(0L, "Greetings from the paging and sorting database side"));
        Optional byId = this.repoSearchAndSorting.findById((Object)databaseSide.getId());
        return byId.orElse(new Hello(-99L, "not found")).getMessage();
    }

    public String greetFromRepoJpa() {
        Hello databaseSide = (Hello)this.helloRepoJpa.save((Object)new Hello(0L, "Greetings from the paging and sorting database side"));
        Optional byId = this.helloRepoJpa.findById((Object)databaseSide.getId());
        return byId.orElse(new Hello(-99L, "not found")).getMessage();
    }

    public String greetFromRepoAnnotation() {
        Hello databaseSide = this.helloRepoAnnotation.save(new Hello(0L, "Greetings from the paging and sorting database side"));
        Optional byId = this.helloRepoAnnotation.findById(Long.valueOf(databaseSide.getId()));
        return byId.orElse(new Hello(-99L, "not found")).getMessage();
    }
}

