/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.javafxsvg;

import com.sun.glass.ui.Screen;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import de.codecentric.centerdevice.javafxsvg.BufferedImageTranscoder;
import de.codecentric.centerdevice.javafxsvg.FixedPixelDensityImageFrame;
import de.codecentric.centerdevice.javafxsvg.SvgDescriptor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;

public class SvgImageLoader
extends ImageLoaderImpl {
    private static final int DEFAULT_SIZE = 400;
    private static final int BYTES_PER_PIXEL = 4;
    private final InputStream input;
    private float maxPixelScale = 0.0f;

    protected SvgImageLoader(InputStream input) {
        super((ImageFormatDescription)SvgDescriptor.getInstance());
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        this.input = input;
    }

    public ImageFrame load(int imageIndex, int width, int height, boolean preserveAspectRatio, boolean smooth) throws IOException {
        if (0 != imageIndex) {
            return null;
        }
        int imageWidth = width > 0 ? width : 400;
        int imageHeight = height > 0 ? height : 400;
        try {
            return this.createImageFrame(imageWidth, imageHeight, this.getPixelScale());
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    public float getPixelScale() {
        if (this.maxPixelScale == 0.0f) {
            this.maxPixelScale = this.calculateMaxRenderScale();
        }
        return this.maxPixelScale;
    }

    public float calculateMaxRenderScale() {
        float maxRenderScale = 0.0f;
        for (Screen screen : Screen.getScreens()) {
            maxRenderScale = Math.max(maxRenderScale, screen.getRenderScale());
        }
        return maxRenderScale;
    }

    private ImageFrame createImageFrame(int width, int height, float pixelScale) throws TranscoderException {
        BufferedImage bufferedImage = this.getTranscodedImage((float)width * pixelScale, (float)height * pixelScale);
        ByteBuffer imageData = this.getImageData(bufferedImage);
        return new FixedPixelDensityImageFrame(ImageStorage.ImageType.RGBA, imageData, bufferedImage.getWidth(), bufferedImage.getHeight(), this.getStride(bufferedImage), null, pixelScale, null);
    }

    private BufferedImage getTranscodedImage(float width, float height) throws TranscoderException {
        BufferedImageTranscoder trans = new BufferedImageTranscoder(2);
        trans.setImageSize(width, height);
        trans.transcode(new TranscoderInput(this.input), null);
        return trans.getBufferedImage();
    }

    private int getStride(BufferedImage bufferedImage) {
        return bufferedImage.getWidth() * 4;
    }

    private ByteBuffer getImageData(BufferedImage bufferedImage) {
        int[] rgb = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        byte[] imageData = new byte[this.getStride(bufferedImage) * bufferedImage.getHeight()];
        this.copyColorToBytes(rgb, imageData);
        return ByteBuffer.wrap(imageData);
    }

    private void copyColorToBytes(int[] rgb, byte[] imageData) {
        if (rgb.length * 4 != imageData.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        for (int i = 0; i < rgb.length; ++i) {
            byte[] bytes = byteBuffer.putInt(rgb[i]).array();
            int dataOffset = 4 * i;
            imageData[dataOffset] = bytes[1];
            imageData[dataOffset + 1] = bytes[2];
            imageData[dataOffset + 2] = bytes[3];
            imageData[dataOffset + 3] = bytes[0];
            byteBuffer.clear();
        }
    }

    public void dispose() {
    }
}

