/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.util;

import com.sun.javafx.stage.StageHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public class StageUtils {
    private static ObservableList<Stage> stages;
    private static ObservableList<Window> windows;

    public static void bringAllToFront() {
        Optional<Stage> focusedStage = StageUtils.getFocusedStage();
        StageUtils.getStages().forEach(stage -> stage.toFront());
        focusedStage.ifPresent(stage -> stage.toFront());
    }

    public static void zoomFocusedStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> {
            ObservableList screens = Screen.getScreensForRectangle((double)stage.getX(), (double)stage.getY(), (double)stage.getWidth(), (double)stage.getHeight());
            if (screens.size() == 1) {
                StageUtils.setStageSize(stage, ((Screen)screens.get(0)).getBounds());
            }
        });
    }

    public static void minimizeFocusedStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> stage.setIconified(true));
    }

    public static void closeCurrentStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> stage.close());
    }

    public static void focusNextStage() {
        ObservableList<Stage> stages = StageUtils.getStages();
        int currentStageIndex = StageUtils.getFocusedStageIndex(stages);
        if (currentStageIndex < stages.size() - 1) {
            ((Stage)stages.get(currentStageIndex + 1)).toFront();
        } else if (stages.size() > 0) {
            ((Stage)stages.get(0)).toFront();
        }
    }

    public static ObservableList<Stage> getStages() {
        if (stages == null) {
            try {
                windows = (ObservableList)Window.class.getMethod("getWindows", new Class[0]).invoke(null, new Object[0]);
                stages = FXCollections.observableArrayList();
                windows.addListener((ListChangeListener)new ListChangeListener<Window>(){

                    public void onChanged(ListChangeListener.Change<? extends Window> c) {
                        StageUtils.updateStages();
                    }
                });
                StageUtils.updateStages();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            if (stages == null) {
                try {
                    stages = (ObservableList)StageHelper.class.getMethod("getStages", new Class[0]).invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return stages;
    }

    private static void updateStages() {
        LinkedList<Stage> newStages = new LinkedList<Stage>();
        for (Window w : windows) {
            if (!(w instanceof Stage)) continue;
            newStages.add((Stage)w);
        }
        stages.setAll(newStages);
    }

    public static Optional<Stage> getFocusedStage() {
        return StageUtils.getStages().stream().filter(stage -> stage.isFocused()).findFirst();
    }

    public static int getFocusedStageIndex(List<Stage> stages) {
        for (int i = 0; i < stages.size(); ++i) {
            if (!stages.get(i).isFocused()) continue;
            return i;
        }
        return -1;
    }

    public static void setStageSize(Stage stage, Rectangle2D screenBounds) {
        stage.setX(screenBounds.getMinX());
        stage.setY(screenBounds.getMinY());
        stage.setWidth(screenBounds.getMaxX() - screenBounds.getMinX());
        stage.setHeight(screenBounds.getMaxY() - screenBounds.getMinY());
    }
}

