/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.glass;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import de.codecentric.centerdevice.util.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;

public class TKSystemMenuAdapter {
    private static final String GLASS_SYSTEM_MENU_BAR = "glassSystemMenuBar";
    private static final String INSERT_MENU = "insertMenu";
    private static final int APPLE_MENU_INDEX = 0;
    private TKSystemMenu systemMenu = TKSystemMenuAdapter.getSystemMenu();
    private MethodHandle insertMenu;
    private MethodHandle getSystemMenuBar;
    private MethodHandle setSystemMenuBar;

    public TKSystemMenuAdapter() throws ReflectiveOperationException {
        Field glassSystemMenuBar = ReflectionUtils.getAccessibleField(this.systemMenu, GLASS_SYSTEM_MENU_BAR);
        this.getSystemMenuBar = MethodHandles.lookup().unreflectGetter(glassSystemMenuBar);
        this.setSystemMenuBar = MethodHandles.lookup().unreflectSetter(glassSystemMenuBar);
        this.insertMenu = ReflectionUtils.getHandle(this.systemMenu, INSERT_MENU, Menu.class, MenuBase.class, Integer.TYPE);
    }

    private static TKSystemMenu getSystemMenu() {
        return Toolkit.getToolkit().getSystemMenu();
    }

    public void setAppleMenu(MenuBase menu) throws Throwable {
        MenuBar glassSystemMenuBar = this.getMenuBar();
        if (glassSystemMenuBar == null) {
            this.createMenuBar();
        } else {
            this.removeMenu(glassSystemMenuBar, 0);
        }
        this.insertMenu(menu, 0);
    }

    private void insertMenu(MenuBase menu, int index) throws Throwable {
        this.insertMenu.invoke(this.systemMenu, null, menu, index);
    }

    private void createMenuBar() throws Throwable {
        this.setSystemMenuBar.invoke(this.systemMenu, Application.GetApplication().createMenuBar());
    }

    public MenuBar getMenuBar() throws Throwable {
        return this.getSystemMenuBar.invoke(this.systemMenu);
    }

    protected void setMenuBar(MenuBar bar) throws Throwable {
        this.setSystemMenuBar.invoke(this.systemMenu, bar);
    }

    public void removeMenu(MenuBar glassSystemMenuBar, int index) {
        if (glassSystemMenuBar.getMenus().size() <= index) {
            return;
        }
        this.clearMenu((Menu)glassSystemMenuBar.getMenus().get(index));
        glassSystemMenuBar.remove(index);
    }

    private void clearMenu(Menu menu) {
        for (int i = menu.getItems().size() - 1; i >= 0; --i) {
            Object o = menu.getItems().get(i);
            if (o instanceof MenuItem) {
                ((MenuItem)o).setCallback(null);
                continue;
            }
            if (!(o instanceof Menu)) continue;
            this.clearMenu((Menu)o);
        }
        menu.setEventHandler(null);
    }
}

