/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.glass;

import com.sun.glass.ui.Application;
import de.codecentric.centerdevice.util.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import javafx.application.Platform;

public class MacApplicationAdapter {
    private MethodHandle hide;
    private MethodHandle hideOtherApplications;
    private MethodHandle unhideAllApplications;
    private Application app = Application.GetApplication();
    private boolean forceQuitOnCmdQ = true;

    public MacApplicationAdapter() throws ReflectiveOperationException {
        this.hide = ReflectionUtils.getHandle(this.app, "_hide", new Class[0]);
        this.hideOtherApplications = ReflectionUtils.getHandle(this.app, "_hideOtherApplications", new Class[0]);
        this.unhideAllApplications = ReflectionUtils.getHandle(this.app, "_unhideAllApplications", new Class[0]);
    }

    public void hide() {
        ReflectionUtils.invokeQuietly(this.hide, this.app);
    }

    public void hideOtherApplications() {
        ReflectionUtils.invokeQuietly(this.hideOtherApplications, this.app);
    }

    public void unhideAllApplications() {
        ReflectionUtils.invokeQuietly(this.unhideAllApplications, this.app);
    }

    public void quit() {
        Application.EventHandler eh = this.app.getEventHandler();
        if (eh != null) {
            eh.handleQuitAction(Application.GetApplication(), System.nanoTime());
        }
        if (this.forceQuitOnCmdQ) {
            Platform.exit();
        }
    }

    public void setForceQuitOnCmdQ(boolean forceQuit) {
        this.forceQuitOnCmdQ = forceQuit;
    }
}

