/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.dialogs.about;

import de.codecentric.centerdevice.dialogs.about.AboutController;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class AboutStageBuilder {
    private final Stage stage;
    private Label version;
    private Label name;
    private Label copyright;
    private WebView credits;
    private ImageView image;

    private AboutStageBuilder(Stage stage) {
        this.stage = stage;
    }

    public Stage build() {
        try {
            this.prepareStage();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.stage;
    }

    private void prepareStage() throws IOException {
        FXMLLoader loader = new FXMLLoader(AboutStageBuilder.class.getClassLoader().getResource("about.fxml"));
        Parent root = (Parent)loader.load();
        AboutController controller = (AboutController)loader.getController();
        if (this.image != null) {
            controller.getContent().getChildren().add((Object)this.image);
        }
        if (this.name != null) {
            controller.getContent().getChildren().add((Object)this.name);
        }
        if (this.version != null) {
            controller.getContent().getChildren().add((Object)this.version);
        }
        if (this.credits != null) {
            controller.getContent().getChildren().add((Object)this.credits);
        }
        if (this.copyright != null) {
            controller.getContent().getChildren().add((Object)this.copyright);
        }
        this.stage.setScene(new Scene(root));
    }

    public AboutStageBuilder withCloseOnFocusLoss() {
        this.stage.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.stage.close();
            }
        });
        return this;
    }

    public AboutStageBuilder withSize(int with, int height) {
        this.stage.setMinWidth((double)with);
        this.stage.setMaxWidth((double)height);
        return this;
    }

    public AboutStageBuilder withTitle(String title) {
        this.stage.setTitle(title);
        return this;
    }

    public AboutStageBuilder withVersionString(String version) {
        this.version = new Label(version);
        this.version.getStyleClass().add((Object)"version");
        return this;
    }

    public AboutStageBuilder withAppName(String name) {
        this.name = new Label(name);
        this.name.getStyleClass().add((Object)"app_name");
        return this;
    }

    public AboutStageBuilder withHtml(String html) {
        this.credits = this.createWebview();
        this.credits.getEngine().loadContent(html);
        return this;
    }

    private WebView createWebview() {
        WebView view = new WebView();
        view.setPrefHeight(150.0);
        return view;
    }

    public AboutStageBuilder withUrl(String url) {
        this.credits = this.createWebview();
        this.credits.getEngine().load(url);
        return this;
    }

    public AboutStageBuilder withCopyright(String copyright) {
        this.copyright = new Label(copyright);
        return this;
    }

    public AboutStageBuilder withImage(Image image) {
        this.image = new ImageView(image);
        this.image.setFitHeight(100.0);
        this.image.setFitWidth(100.0);
        return this;
    }

    public static AboutStageBuilder start(String title) {
        Stage aboutStage = new Stage();
        aboutStage.setResizable(false);
        return new AboutStageBuilder(aboutStage).withTitle(title).withSize(300, 300);
    }
}

