/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.codecentric.ccunit.web.conditions;

import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitForCondition extends AbstractWebCondition {
	private static final long DEFAULT_TIMEOUT = 10;

	private By element;

	private long timeout;

	public WaitForCondition(By element) {
		this(element, DEFAULT_TIMEOUT);
	}

	public WaitForCondition(By element, long timeout) {
		this.element = element;
		this.timeout = timeout;
	}

	public WaitForCondition withTimeout(long timeout) {
		this.timeout = timeout;
		return this;
	}

	@Override
	public void fulfill() {
		WebDriverWait waiting = new WebDriverWait(getWebDriver(), timeout);
		waiting.until(ExpectedConditions.presenceOfElementLocated(element));
	}
}
