/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.listener;

import de.codecentric.batch.logging.DefaultJobLogFileNameCreator;
import de.codecentric.batch.logging.JobLogFileNameCreator;
import org.slf4j.MDC;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

public class LoggingListener
implements JobExecutionListener,
StepExecutionListener,
Ordered {
    private JobLogFileNameCreator jobLogFileNameCreator = new DefaultJobLogFileNameCreator();
    public static final String JOBLOG_FILENAME = "jobLogFileName";

    public void beforeJob(JobExecution jobExecution) {
        this.insertValuesIntoMDC(jobExecution);
    }

    private void insertValuesIntoMDC(JobExecution jobExecution) {
        MDC.put((String)JOBLOG_FILENAME, (String)this.jobLogFileNameCreator.getBaseName(jobExecution));
    }

    public void afterJob(JobExecution jobExecution) {
        this.removeValuesFromMDC();
    }

    private void removeValuesFromMDC() {
        MDC.remove((String)JOBLOG_FILENAME);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.insertValuesIntoMDC(stepExecution.getJobExecution());
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        this.removeValuesFromMDC();
        return null;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Autowired(required=false)
    public void setJobLogFileNameCreator(JobLogFileNameCreator jobLogFileNameCreator) {
        this.jobLogFileNameCreator = jobLogFileNameCreator;
    }
}

