/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.ListenerProvider;
import de.codecentric.batch.metrics.BatchMetricsImpl;
import de.codecentric.batch.metrics.MetricsListener;
import de.codecentric.batch.metrics.ReaderProcessorWriterMetricsAspect;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.Set;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"batch.metrics.enabled"})
@Configuration
public class MetricsConfiguration
implements ListenerProvider {
    @Autowired
    private MeterRegistry meterRegistry;

    @Bean
    public BatchMetricsImpl batchMetrics() {
        return new BatchMetricsImpl();
    }

    @ConditionalOnProperty(value={"batch.metrics.profiling.readprocesswrite.enabled"})
    @Bean
    public ReaderProcessorWriterMetricsAspect batchMetricsAspects() {
        return new ReaderProcessorWriterMetricsAspect(this.meterRegistry);
    }

    @Bean
    public MetricsListener metricsListener() {
        return new MetricsListener(this.meterRegistry);
    }

    @Override
    public Set<JobExecutionListener> jobExecutionListeners() {
        HashSet<JobExecutionListener> listeners = new HashSet<JobExecutionListener>();
        listeners.add(this.metricsListener());
        return listeners;
    }

    @Override
    public Set<StepExecutionListener> stepExecutionListeners() {
        HashSet<StepExecutionListener> listeners = new HashSet<StepExecutionListener>();
        listeners.add((StepExecutionListener)this.metricsListener());
        return listeners;
    }
}

