/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import de.codecentric.batch.metrics.MetricsOutputFormatter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.Search;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.core.Ordered;

public class MetricsListener
extends StepExecutionListenerSupport
implements Ordered,
JobExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsListener.class);
    public static final String METRIC_NAME = "batch.metrics";
    private MeterRegistry meterRegistry;
    private MetricsOutputFormatter metricsOutputFormatter = new SimpleMetricsOutputFormatter();

    public MetricsListener(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void beforeJob(JobExecution jobExecution) {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        long stepDuration = System.currentTimeMillis() - stepExecution.getStartTime().getTime();
        this.meterRegistry.gauge(METRIC_NAME, Arrays.asList(new ImmutableTag("context", this.getStepExecutionIdentifier(stepExecution)), new ImmutableTag("name", "duration")), (Number)stepDuration);
        long itemCount = stepExecution.getWriteCount() + stepExecution.getSkipCount();
        this.meterRegistry.gauge(METRIC_NAME, Arrays.asList(new ImmutableTag("context", this.getStepExecutionIdentifier(stepExecution)), new ImmutableTag("name", "item.count")), (Number)itemCount);
        long durationPerItem = 0L;
        if (itemCount > 0L) {
            durationPerItem = stepDuration / itemCount;
        }
        this.meterRegistry.gauge(METRIC_NAME, Arrays.asList(new ImmutableTag("context", this.getStepExecutionIdentifier(stepExecution)), new ImmutableTag("name", "item.duration")), (Number)durationPerItem);
        Set metrics = stepExecution.getExecutionContext().entrySet();
        for (Map.Entry metric : metrics) {
            if (!(metric.getValue() instanceof Number)) continue;
            this.meterRegistry.gauge(METRIC_NAME, Arrays.asList(new ImmutableTag("context", this.getStepExecutionIdentifier(stepExecution)), new ImmutableTag("name", (String)metric.getKey())), (Number)metric.getValue());
        }
        return null;
    }

    public void afterJob(JobExecution jobExecution) {
        long jobDuration = jobExecution.getEndTime().getTime() - jobExecution.getStartTime().getTime();
        this.meterRegistry.gauge(METRIC_NAME, Arrays.asList(new ImmutableTag("context", jobExecution.getJobInstance().getJobName()), new ImmutableTag("name", "duration")), (Number)jobDuration);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Search search = this.meterRegistry.find(METRIC_NAME);
        LOGGER.info(this.metricsOutputFormatter.format(search.gauges(), search.timers()));
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    private String getStepExecutionIdentifier(StepExecution stepExecution) {
        return stepExecution.getJobExecution().getJobInstance().getJobName() + "." + stepExecution.getStepName();
    }

    public void setMetricsOutputFormatter(MetricsOutputFormatter metricsOutputFormatter) {
        this.metricsOutputFormatter = metricsOutputFormatter;
    }

    private static class SimpleMetricsOutputFormatter
    implements MetricsOutputFormatter {
        private SimpleMetricsOutputFormatter() {
        }

        @Override
        public String format(Collection<Gauge> gauges, Collection<Timer> timers) {
            StringBuilder builder = new StringBuilder("\n########## Metrics Start ##########\n");
            gauges.stream().forEach(gauge -> {
                builder.append("Gauge [" + gauge.getId() + "]: ");
                builder.append(gauge.value() + "\n");
            });
            timers.stream().forEach(timer -> {
                builder.append("Timer [" + timer.getId() + "]: ");
                builder.append("totalTime=" + timer.totalTime(timer.baseTimeUnit()) + " " + (Object)((Object)timer.baseTimeUnit()) + "\n");
            });
            builder.append("########## Metrics End ############");
            return builder.toString();
        }
    }
}

