/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import de.codecentric.batch.metrics.BatchMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class BatchMetricsImpl
extends TransactionSynchronizationAdapter
implements BatchMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchMetricsImpl.class);
    private ThreadLocal<MetricContainer> metricContainer;
    private final Object serviceKey = new Object();

    public BatchMetricsImpl() {
        this.metricContainer = new ThreadLocal();
    }

    @Override
    public void increment(String metricName) {
        this.increment(metricName, 1L);
    }

    @Override
    public void increment(String metricName, Long value) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary();
            this.metricContainer.get().metrics.add((Pair<String, ? extends Number>)Pair.of((Object)metricName, (Object)value));
        } else {
            this.incrementNonTransactional(metricName, value);
        }
    }

    @Override
    public void decrement(String metricName) {
        this.decrement(metricName, -1L);
    }

    @Override
    public void decrement(String metricName, Long value) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary();
            this.metricContainer.get().metrics.add((Pair<String, ? extends Number>)Pair.of((Object)metricName, (Object)(-value.longValue())));
        } else {
            this.decrementNonTransactional(metricName, value);
        }
    }

    @Override
    public void reset(String metricName) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary();
            this.metricContainer.get().metrics.add((Pair<String, ? extends Number>)Pair.of((Object)metricName, (Object)null));
        } else {
            this.resetNonTransactional(metricName);
        }
    }

    @Override
    public void submit(String metricName, double value) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary();
            this.metricContainer.get().metrics.add((Pair<String, ? extends Number>)Pair.of((Object)metricName, (Object)value));
        } else {
            this.set(metricName, value);
        }
    }

    @Override
    public void incrementNonTransactional(String metricName) {
        this.incrementNonTransactional(metricName, 1L);
    }

    @Override
    public void incrementNonTransactional(String metricName, Long value) {
        this.modifyCounter(metricName, value);
    }

    @Override
    public void decrementNonTransactional(String metricName) {
        this.decrementNonTransactional(metricName, -1L);
    }

    @Override
    public void decrementNonTransactional(String metricName, Long value) {
        this.modifyCounter(metricName, -value.longValue());
    }

    @Override
    public void resetNonTransactional(String metricName) {
        this.remove(metricName);
    }

    @Override
    public void submitNonTransactional(String metricName, double value) {
        this.set(metricName, value);
    }

    public void afterCompletion(int status) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entered afterCompletion with status {}.", (Object)status);
        }
        if (status == 0) {
            MetricContainer currentMetricContainer = this.metricContainer.get();
            for (Pair<String, ? extends Number> metric : currentMetricContainer.metrics) {
                if (metric.getRight() instanceof Long) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Increment {}.", metric);
                    }
                    this.incrementNonTransactional((String)metric.getLeft(), (Long)metric.getRight());
                    continue;
                }
                if (metric.getRight() instanceof Double) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Gauge {}.", metric);
                    }
                    this.set((String)metric.getLeft(), (Double)metric.getRight());
                    continue;
                }
                if (metric.getRight() != null) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Reset {}.", metric);
                }
                this.remove((String)metric.getLeft());
            }
        }
        this.metricContainer.remove();
        if (TransactionSynchronizationManager.hasResource((Object)this.serviceKey)) {
            TransactionSynchronizationManager.unbindResource((Object)this.serviceKey);
        }
    }

    private synchronized void modifyCounter(String metricName, Long value) {
        StepExecution stepExecution = this.getStepExecution();
        Long oldValue = 0L;
        if (stepExecution.getExecutionContext().containsKey(metricName)) {
            oldValue = stepExecution.getExecutionContext().getLong(metricName);
        }
        stepExecution.getExecutionContext().put(metricName, (Object)(oldValue + value));
    }

    private void remove(String metricName) {
        StepExecution stepExecution = this.getStepExecution();
        if (stepExecution.getExecutionContext().containsKey(metricName)) {
            stepExecution.getExecutionContext().remove(metricName);
        }
    }

    private void set(String metricName, double value) {
        StepExecution stepExecution = this.getStepExecution();
        stepExecution.getExecutionContext().put(metricName, (Object)value);
    }

    private StepExecution getStepExecution() {
        if (StepSynchronizationManager.getContext() != null) {
            return StepSynchronizationManager.getContext().getStepExecution();
        }
        return null;
    }

    private void initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.serviceKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.serviceKey, (Object)new StringBuffer());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this);
        }
        if (this.metricContainer.get() == null) {
            this.metricContainer.set(new MetricContainer());
        }
    }

    private static class MetricContainer {
        List<Pair<String, ? extends Number>> metrics = new ArrayList<Pair<String, ? extends Number>>();

        private MetricContainer() {
        }
    }
}

