package de.codecamp.maven.delayment;


import de.codecamp.maven.delayment.model.RecordedArtifacts;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;


@Mojo(name = RecordArtifactsMojo.MOJO_NAME, defaultPhase = LifecyclePhase.VERIFY)
public class RecordArtifactsMojo
  extends
    AbstractDelaymentMojo
{

  public static final String MOJO_NAME = "recordArtifacts";


  @Override
  public void execute()
    throws MojoExecutionException
  {
    Path artifactsFilePath = getArtifactsFilePath();

    getLog().info("Recording artifacts for delayed deployment to '" + artifactsFilePath + "'.");


    RecordedArtifacts artifacts = new RecordedArtifacts();

    File mainArtifactFile = getProject().getArtifact().getFile();
    if (mainArtifactFile != null)
    {
      getLog().info("Main artifact file: " + mainArtifactFile);
      artifacts.setMainFile(mainArtifactFile);
    }

    for (Artifact attachedArtifact : getProject().getAttachedArtifacts())
    {
      getLog().info("Attached artifact: " + getProject().getArtifact().getType() + " - "
          + attachedArtifact.getClassifier() + " - " + attachedArtifact.getFile());
      artifacts.getArtifacts()
          .add(new RecordedArtifacts.Artifact(getProject().getArtifact().getType(),
              attachedArtifact.getClassifier(), attachedArtifact.getFile()));
    }


    try
    {
      Files.createDirectories(Paths.get(getProject().getBuild().getDirectory()));

      try (Writer out = Files.newBufferedWriter(artifactsFilePath, StandardCharsets.UTF_8))
      {
        getGson().toJson(artifacts, out);
      }
    }
    catch (IOException | RuntimeException ex)
    {
      throw new MojoExecutionException("Failed to record artifacts to '" + artifactsFilePath + "'.",
          ex);
    }
  }

}
