/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.gallop.xrechnung.model;

public enum TaxCategory {
    STANDARD_RATE("S"),
    ZERO_RATED_GOODS("Z"),
    EXEMPT_FROM_TAX("E"),
    REVERSE_CHARGE("AE"),
    INTRA_COMMUNITY_SUPPLY("K"),
    FREE_EXPORT_ITEM("G"),
    SERVICES_OUTSIDE_SCOPE_OF_TAX("O"),
    CANARY_ISLANDS_GENERAL_INDIRECT_TAX("L"),
    CEUTA_AND_MELILLA_TAX("M");

    private final String categoryCode;

    private TaxCategory(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public static TaxCategory fromCategory(String category) {
        for (TaxCategory taxCategory : TaxCategory.values()) {
            if (!taxCategory.categoryCode.equalsIgnoreCase(category)) continue;
            return taxCategory;
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }
}

