/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.gallop.xrechnung.model;

import de.codebarista.gallop.xrechnung.model.CreditTransfer;
import de.codebarista.gallop.xrechnung.model.DirectDebit;
import de.codebarista.gallop.xrechnung.model.PaymentCardInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PaymentInstructions {
    private String meansType;
    private String meansText;
    private String remittanceInfo;
    private String paymentTerms;
    private List<CreditTransfer> creditTransfers = new ArrayList<CreditTransfer>();
    private PaymentCardInformation paymentCardInformation;
    private DirectDebit directDebit;

    public static PaymentInstructions create() {
        return new PaymentInstructions();
    }

    public PaymentInstructions meansType(String meansType) {
        this.meansType = meansType;
        return this;
    }

    public PaymentInstructions meansText(String meansText) {
        this.meansText = meansText;
        return this;
    }

    public PaymentInstructions remittanceInfo(String remittanceInfo) {
        this.remittanceInfo = remittanceInfo;
        return this;
    }

    public PaymentInstructions paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    public PaymentInstructions addCreditTransfer(CreditTransfer creditTransfer) {
        this.creditTransfers.add(creditTransfer);
        return this;
    }

    public PaymentInstructions creditTransfers(List<CreditTransfer> creditTransfers) {
        this.creditTransfers = new ArrayList<CreditTransfer>(creditTransfers);
        return this;
    }

    public void clearCreditTransfer() {
        this.creditTransfers.clear();
    }

    public PaymentInstructions paymentCardInformation(PaymentCardInformation paymentCardInformation) {
        this.paymentCardInformation = paymentCardInformation;
        return this;
    }

    public PaymentInstructions directDebit(DirectDebit directDebit) {
        this.directDebit = directDebit;
        return this;
    }

    public String getMeansType() {
        return this.meansType;
    }

    public String getMeansText() {
        return this.meansText;
    }

    public String getRemittanceInfo() {
        return this.remittanceInfo;
    }

    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public List<CreditTransfer> getCreditTransfers() {
        return Collections.unmodifiableList(this.creditTransfers);
    }

    public PaymentCardInformation getPaymentCardInformation() {
        return this.paymentCardInformation;
    }

    public DirectDebit getDirectDebit() {
        return this.directDebit;
    }
}

