/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.gallop.xrechnung.model;

import de.codebarista.gallop.xrechnung.model.ItemAttribute;
import de.codebarista.gallop.xrechnung.model.NetAmount;
import de.codebarista.gallop.xrechnung.model.Vat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Item
implements NetAmount<Item> {
    private Long id;
    private Long quantity;
    private String unitCode;
    private BigDecimal itemTotalNetAmount;
    private String name;
    private String description;
    private BigDecimal unitPrice;
    private Vat vat;
    private String sellerAssignedId;
    private List<ItemAttribute> itemAttributes = new ArrayList<ItemAttribute>();

    public static Item create() {
        return new Item();
    }

    public Item id(Long id) {
        this.id = id;
        return this;
    }

    public Item quantity(Long quantity) {
        this.quantity = quantity;
        return this;
    }

    public Item unitCode(String unitCode) {
        this.unitCode = unitCode;
        return this;
    }

    public Item itemTotalNetAmount(BigDecimal itemTotalNetAmount) {
        this.itemTotalNetAmount = itemTotalNetAmount;
        return this;
    }

    @Override
    public Item netAmount(BigDecimal amount) {
        this.itemTotalNetAmount = amount;
        return this;
    }

    public Item name(String name) {
        this.name = name;
        return this;
    }

    public Item description(String description) {
        this.description = description;
        return this;
    }

    public Item unitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    public Item vat(Vat vat) {
        this.vat = vat;
        return this;
    }

    public Item sellerAssignedId(String sellerAssignedId) {
        this.sellerAssignedId = sellerAssignedId;
        return this;
    }

    public Item addItemAttribute(ItemAttribute itemAttribute) {
        this.itemAttributes.add(itemAttribute);
        return this;
    }

    public Item itemAttributes(List<ItemAttribute> itemAttributes) {
        this.itemAttributes = new ArrayList<ItemAttribute>(itemAttributes);
        return this;
    }

    public void clearItemAttributes() {
        this.itemAttributes.clear();
    }

    public Long getId() {
        return this.id;
    }

    public Long getQuantity() {
        return this.quantity;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public BigDecimal getItemTotalNetAmount() {
        return this.itemTotalNetAmount;
    }

    @Override
    public BigDecimal getNetAmount() {
        return this.itemTotalNetAmount;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public Vat getVat() {
        return this.vat;
    }

    @Override
    public BigDecimal getVatRate() {
        return this.vat.getRate();
    }

    public String getSellerAssignedId() {
        return this.sellerAssignedId;
    }

    public List<ItemAttribute> getItemAttributes() {
        return Collections.unmodifiableList(this.itemAttributes);
    }
}

