/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.gallop.xrechnung.model;

import de.codebarista.gallop.xrechnung.model.Allowance;
import de.codebarista.gallop.xrechnung.model.Charge;
import de.codebarista.gallop.xrechnung.model.DeliveryInformation;
import de.codebarista.gallop.xrechnung.model.InvoiceNote;
import de.codebarista.gallop.xrechnung.model.Item;
import de.codebarista.gallop.xrechnung.model.PaymentInstructions;
import de.codebarista.gallop.xrechnung.model.PrecedingInvoiceReference;
import de.codebarista.gallop.xrechnung.model.SellerOrBuyer;
import de.codebarista.gallop.xrechnung.model.Vat;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Invoice {
    private String documentId;
    private OffsetDateTime issueDate;
    private String documentTypeCode;
    private String currency;
    private String leitwegId;
    private PaymentInstructions paymentInstructions;
    private SellerOrBuyer seller;
    private SellerOrBuyer buyer;
    private DeliveryInformation deliveryInfo;
    private List<Item> items = new ArrayList<Item>();
    private List<Vat> vatTotals = new ArrayList<Vat>();
    private List<PrecedingInvoiceReference> precedingInvoiceReferences = new ArrayList<PrecedingInvoiceReference>();
    private BigDecimal lineTotalAmount;
    private BigDecimal allowanceTotalAmount;
    private BigDecimal chargeTotalAmount;
    private BigDecimal taxBasisTotalAmount;
    private BigDecimal taxTotalAmount;
    private BigDecimal grandTotalAmount;
    private BigDecimal duePayableAmount;
    private String salesOrderReference;
    private List<InvoiceNote> invoiceNotes = new ArrayList<InvoiceNote>();
    private List<Allowance> allowances = new ArrayList<Allowance>();
    private List<Charge> charges = new ArrayList<Charge>();

    public static Invoice create() {
        return new Invoice();
    }

    public Invoice documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    public Invoice issueDate(OffsetDateTime issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public Invoice documentTypeCode(String documentTypeCode) {
        this.documentTypeCode = documentTypeCode;
        return this;
    }

    public Invoice currency(String currency) {
        this.currency = currency;
        return this;
    }

    public Invoice leitwegId(String leitwegId) {
        this.leitwegId = leitwegId;
        return this;
    }

    public Invoice paymentInstructions(PaymentInstructions paymentInstructions) {
        this.paymentInstructions = paymentInstructions;
        return this;
    }

    public Invoice seller(SellerOrBuyer seller) {
        this.seller = seller;
        return this;
    }

    public Invoice buyer(SellerOrBuyer buyer) {
        this.buyer = buyer;
        return this;
    }

    public Invoice deliveryInfo(DeliveryInformation deliveryInfo) {
        this.deliveryInfo = deliveryInfo;
        return this;
    }

    public Invoice addItem(Item item) {
        this.items.add(item);
        return this;
    }

    public Invoice items(List<Item> items) {
        this.items = new ArrayList<Item>(items);
        return this;
    }

    public void clearItems() {
        this.items.clear();
    }

    public Invoice addVatTotal(Vat vatTotal) {
        this.vatTotals.add(vatTotal);
        return this;
    }

    public Invoice vatTotals(List<Vat> vatTotals) {
        this.vatTotals = new ArrayList<Vat>(vatTotals);
        return this;
    }

    public void clearVatTotals() {
        this.vatTotals.clear();
    }

    public Invoice addPrecedingInvoiceReference(PrecedingInvoiceReference precedingInvoiceReference) {
        this.precedingInvoiceReferences.add(precedingInvoiceReference);
        return this;
    }

    public Invoice precedingInvoiceReferences(List<PrecedingInvoiceReference> precedingInvoiceReferences) {
        this.precedingInvoiceReferences = new ArrayList<PrecedingInvoiceReference>(precedingInvoiceReferences);
        return this;
    }

    public void clearPrecedingInvoiceReferences() {
        this.precedingInvoiceReferences.clear();
    }

    public Invoice lineTotalAmount(BigDecimal lineTotalAmount) {
        this.lineTotalAmount = lineTotalAmount;
        return this;
    }

    public Invoice allowanceTotalAmount(BigDecimal allowanceTotalAmount) {
        this.allowanceTotalAmount = allowanceTotalAmount;
        return this;
    }

    public Invoice chargeTotalAmount(BigDecimal chargeTotalAmount) {
        this.chargeTotalAmount = chargeTotalAmount;
        return this;
    }

    public Invoice taxBasisTotalAmount(BigDecimal taxBasisTotalAmount) {
        this.taxBasisTotalAmount = taxBasisTotalAmount;
        return this;
    }

    public Invoice taxTotalAmount(BigDecimal taxTotalAmount) {
        this.taxTotalAmount = taxTotalAmount;
        return this;
    }

    public Invoice grandTotalAmount(BigDecimal grandTotalAmount) {
        this.grandTotalAmount = grandTotalAmount;
        return this;
    }

    public Invoice duePayableAmount(BigDecimal duePayableAmount) {
        this.duePayableAmount = duePayableAmount;
        return this;
    }

    public Invoice salesOrderReference(String salesOrderReference) {
        this.salesOrderReference = salesOrderReference;
        return this;
    }

    public Invoice addInvoiceNote(InvoiceNote invoiceNote) {
        this.invoiceNotes.add(invoiceNote);
        return this;
    }

    public Invoice invoiceNotes(List<InvoiceNote> invoiceNotes) {
        this.invoiceNotes = new ArrayList<InvoiceNote>(invoiceNotes);
        return this;
    }

    public void clearInvoiceNotes() {
        this.invoiceNotes.clear();
    }

    public Invoice addAllowance(Allowance allowance) {
        this.allowances.add(allowance);
        return this;
    }

    public Invoice allowances(List<Allowance> allowances) {
        this.allowances = new ArrayList<Allowance>(allowances);
        return this;
    }

    public void clearAllowances() {
        this.allowances.clear();
    }

    public Invoice addCharge(Charge charge) {
        this.charges.add(charge);
        return this;
    }

    public Invoice charges(List<Charge> charges) {
        this.charges = new ArrayList<Charge>(charges);
        return this;
    }

    public void clearCharges() {
        this.charges.clear();
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public OffsetDateTime getIssueDate() {
        return this.issueDate;
    }

    public String getDocumentTypeCode() {
        return this.documentTypeCode;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getLeitwegId() {
        return this.leitwegId;
    }

    public PaymentInstructions getPaymentInstructions() {
        return this.paymentInstructions;
    }

    public SellerOrBuyer getSeller() {
        return this.seller;
    }

    public SellerOrBuyer getBuyer() {
        return this.buyer;
    }

    public DeliveryInformation getDeliveryInfo() {
        return this.deliveryInfo;
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public List<Vat> getVatTotals() {
        return Collections.unmodifiableList(this.vatTotals);
    }

    public List<PrecedingInvoiceReference> getPrecedingInvoiceReferences() {
        return Collections.unmodifiableList(this.precedingInvoiceReferences);
    }

    public BigDecimal getLineTotalAmount() {
        return this.lineTotalAmount;
    }

    public BigDecimal getAllowanceTotalAmount() {
        return this.allowanceTotalAmount;
    }

    public BigDecimal getChargeTotalAmount() {
        return this.chargeTotalAmount;
    }

    public BigDecimal getTaxBasisTotalAmount() {
        return this.taxBasisTotalAmount;
    }

    public BigDecimal getTaxTotalAmount() {
        return this.taxTotalAmount;
    }

    public BigDecimal getGrandTotalAmount() {
        return this.grandTotalAmount;
    }

    public BigDecimal getDuePayableAmount() {
        return this.duePayableAmount;
    }

    public String getSalesOrderReference() {
        return this.salesOrderReference;
    }

    public List<InvoiceNote> getInvoiceNotes() {
        return Collections.unmodifiableList(this.invoiceNotes);
    }

    public List<Allowance> getAllowances() {
        return Collections.unmodifiableList(this.allowances);
    }

    public List<Charge> getCharges() {
        return Collections.unmodifiableList(this.charges);
    }
}

