/*
 * Decompiled with CFR 0.152.
 */
package de.codebarista.gallop.xrechnung;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlDocumentBuilder {
    private final Document document;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private Element rootNode;

    public XmlDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.document = docBuilder.newDocument();
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(uri, prefix);
        this.setNamespaceAttributes();
    }

    public Element createElement(String namespaceUri, String elementName) {
        String prefix = this.namespaces.get(namespaceUri);
        if (prefix == null) {
            throw new IllegalArgumentException("Unknown namespace URI " + namespaceUri);
        }
        return this.document.createElementNS(namespaceUri, prefix + ":" + elementName);
    }

    public void setRootElement(Element element) {
        if (this.document.hasChildNodes()) {
            throw new IllegalStateException("Root node already set");
        }
        this.document.appendChild(element);
        this.rootNode = element;
        this.setNamespaceAttributes();
    }

    private void setNamespaceAttributes() {
        if (this.rootNode == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            this.rootNode.setAttribute("xmlns:" + entry.getValue(), entry.getKey());
        }
    }

    public DOMSource getDomSource() {
        return new DOMSource(this.document);
    }
}

