/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.codesourcery.versiontracker.client.api.IAPIClient;
import de.codesourcery.versiontracker.common.APIRequest;
import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.ArtifactResponse;
import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.IVersionProvider;
import de.codesourcery.versiontracker.common.IVersionStorage;
import de.codesourcery.versiontracker.common.JSONHelper;
import de.codesourcery.versiontracker.common.QueryRequest;
import de.codesourcery.versiontracker.common.QueryResponse;
import de.codesourcery.versiontracker.common.RequestsPerHour;
import de.codesourcery.versiontracker.common.ServerVersion;
import de.codesourcery.versiontracker.common.Utils;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.common.VersionInfo;
import de.codesourcery.versiontracker.common.server.APIImpl;
import de.codesourcery.versiontracker.common.server.IBackgroundUpdater;
import de.codesourcery.versiontracker.server.APIImplHolder;
import de.codesourcery.versiontracker.server.APIServlet;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class APIServlet
extends HttpServlet {
    private static final Logger LOG = LogManager.getLogger(APIServlet.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.*?)}");
    private static final ObjectMapper JSON_MAPPER = JSONHelper.newObjectMapper();
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final RequestsPerHour requestsPerHour = new RequestsPerHour();
    private boolean artifactUpdatesEnabled = true;

    public APIServlet() {
        LOG.info("APIServlet(): Instance created");
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (LOG.isInfoEnabled()) {
            LOG.debug("service(): Incoming request from " + req.getRemoteAddr());
        }
        long start = System.currentTimeMillis();
        try {
            super.service(req, res);
        }
        catch (RuntimeException e) {
            LOG.error("service(): Uncaught exception", (Throwable)e);
            throw e;
        }
        finally {
            if (LOG.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - start;
                LOG.info("service(): Request finished after " + elapsed + " ms");
            }
        }
    }

    private static String toString(ZonedDateTime dt) {
        return dt.format(formatter) + " UTC";
    }

    private void sendFileFromClasspath(String classpathLocation, HttpServletResponse resp, String contentType) throws IOException {
        this.sendFileFromClasspath(classpathLocation, resp, contentType, null);
    }

    private void sendFileFromClasspath(String classpathLocation, HttpServletResponse resp, String contentType, Map<String, String> placeholderValues) throws IOException {
        InputStream in = APIServlet.class.getResourceAsStream(classpathLocation);
        if (in == null) {
            LOG.error("sendFileFromClasspath(): File not found - " + classpathLocation + " (" + contentType + ")");
            resp.sendError(404);
            return;
        }
        resp.setContentType(contentType);
        try (InputStream inputStream = in;){
            String input = new String(in.readAllBytes(), StandardCharsets.UTF_8);
            if (placeholderValues != null && !placeholderValues.isEmpty()) {
                input = APIServlet.resolvePlaceholders((String)input, placeholderValues);
            }
            resp.getWriter().write(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RequestsPerHour requestsPerHour = this.requestsPerHour;
        synchronized (requestsPerHour) {
            this.requestsPerHour.update();
        }
        resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        String uri = req.getRequestURI();
        if (uri.contains("/scripts/")) {
            int idx = uri.indexOf("/scripts/");
            String scriptName = uri.substring(idx + "/scripts/".length());
            String classpathLocation = "/scripts/" + scriptName;
            this.sendFileFromClasspath(classpathLocation, resp, "text/javascript;charset=UTF-8");
            return;
        }
        if (uri.contains("/css/")) {
            int idx = uri.indexOf("/css/");
            String scriptName = uri.substring(idx + "/css/".length());
            String classpathLocation = "/css/" + scriptName;
            this.sendFileFromClasspath(classpathLocation, resp, "text/css;charset=UTF-8");
            return;
        }
        APIImpl impl = APIImplHolder.getInstance().getImpl();
        IVersionStorage storage = impl.getVersionTracker().getStorage();
        if (uri.endsWith("/autocomplete")) {
            String kind = req.getParameter("kind");
            String userInput = req.getParameter("userInput");
            String[] choices = switch (kind) {
                case "groupId" -> (String[])storage.getAllVersions().stream().filter(x -> x.artifact.groupId.contains(userInput)).map(x -> x.artifact.groupId).sorted().distinct().limit(10L).toArray(String[]::new);
                case "artifactId" -> {
                    String groupId = req.getParameter("groupId");
                    Predicate<VersionInfo> pred = userInput == null || userInput.isBlank() ? x -> true : x -> x.artifact.artifactId.contains(userInput);
                    yield (String[])storage.getAllVersions().stream().filter(x -> x.artifact.groupId.equals(groupId)).filter(pred).map(x -> x.artifact.artifactId).sorted().distinct().limit(10L).toArray(String[]::new);
                }
                default -> throw new RuntimeException("Unknown auto completion type");
            };
            String json = JSON_MAPPER.writeValueAsString((Object)choices);
            resp.setContentType("application/json");
            resp.getWriter().write(json);
            return;
        }
        if (uri.endsWith("/mavencentralstatus")) {
            String status;
            IVersionProvider.Statistics mavenCentralAPIStats = impl.getVersionTracker().getVersionProvider().getStatistics();
            if (mavenCentralAPIStats.httpRequestCountByResponseCode.isEmpty()) {
                status = "unknown";
            } else {
                Set httpStatusCodes = mavenCentralAPIStats.httpRequestCountByResponseCode.keySet();
                httpStatusCodes.removeIf(x -> x == 200 || x == 404);
                status = httpStatusCodes.isEmpty() ? "operational" : "error";
            }
            String json = JSON_MAPPER.writeValueAsString(Map.of("apiStatus", status));
            resp.setContentType("application/json");
            resp.getWriter().write(json);
            return;
        }
        boolean triggerRefresh = uri.endsWith("/triggerRefresh");
        if (uri.endsWith("/simplequery") || triggerRefresh) {
            Artifact a = new Artifact();
            a.artifactId = req.getParameter("artifactId");
            if (StringUtils.isBlank((CharSequence)a.artifactId)) {
                resp.sendError(500, "Missing artifactId request parameter");
                return;
            }
            a.groupId = req.getParameter("groupId");
            if (StringUtils.isBlank((CharSequence)a.groupId)) {
                resp.sendError(500, "Missing groupId request parameter");
                return;
            }
            a.setClassifier(req.getParameter("classifier"));
            a.type = req.getParameter("type");
            if (a.type == null) {
                a.type = "jar";
            }
            if (triggerRefresh) {
                BiPredicate<VersionInfo, Artifact> requiresUpdate;
                a.version = req.getParameter("version");
                if (this.artifactUpdatesEnabled) {
                    IBackgroundUpdater updater = impl.getBackgroundUpdater();
                    requiresUpdate = (arg_0, arg_1) -> ((IBackgroundUpdater)updater).requiresUpdate(arg_0, arg_1);
                } else {
                    requiresUpdate = (optVersionInfo, art) -> false;
                }
                try {
                    if (StringUtils.isNotBlank((CharSequence)a.version)) {
                        impl.getVersionTracker().getVersionInfo(List.of(a), requiresUpdate);
                    } else {
                        impl.getVersionTracker().forceUpdate(a.groupId, a.artifactId);
                    }
                }
                catch (Exception e) {
                    LOG.error("Caught exception while trying to force version update for " + a, (Throwable)e);
                    resp.sendError(500, "Version update failed for " + a);
                }
                return;
            }
            ArrayList<VersionInfo> result = new ArrayList<VersionInfo>();
            if (req.getParameter("regex") != null) {
                result.addAll(storage.getAllVersions(a.groupId, a.artifactId));
                result.removeIf(toCheck -> {
                    if (!Objects.equals(toCheck.artifact.type, a.type)) {
                        return true;
                    }
                    return a.getClassifier() != null && !Objects.equals(toCheck.artifact.getClassifier(), a.getClassifier());
                });
            } else {
                storage.getVersionInfo(a).ifPresent(result::add);
            }
            resp.setContentType("application/json");
            resp.getWriter().write(JSON_MAPPER.writeValueAsString(result));
            return;
        }
        if (uri.endsWith("/resetstatistics")) {
            LOG.info("doGet(): Resetting statistics");
            storage.resetStatistics();
            impl.getVersionTracker().getVersionProvider().resetStatistics();
            impl.getBackgroundUpdater().resetStatistics();
            APIServlet.redirectToHomePage((HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        StatusInformation storageStats = new StatusInformation(this.requestsPerHour.createCopy(), (String)this.getApplicationVersion().orElse(null), (String)this.getSHA1Hash().orElse(null), storage.getStatistics());
        String queryString = req.getQueryString();
        if ("json".equalsIgnoreCase(queryString)) {
            String json = JSON_MAPPER.writeValueAsString((Object)storageStats);
            resp.setContentType("application/json");
            resp.getWriter().write(json);
        } else {
            String rowFragment = "<div class=\"row\">\n  <div class=\"cellName\">%s</div><div class=\"cellValue\">%s</div>\n</div>\n";
            StringBuilder fragments = new StringBuilder();
            Consumer<Object> appender = toAppend -> fragments.append(toAppend).append("\n");
            BiConsumer<String, Object> keyValue = (k, v) -> appender.accept("<div class=\"row\">\n  <div class=\"cellName\">%s</div><div class=\"cellValue\">%s</div>\n</div>\n".formatted(k, Objects.toString(v)));
            keyValue.accept("Total artifacts", storageStats.storageStatistics.totalArtifactCount);
            keyValue.accept("Total versions", storageStats.storageStatistics.totalVersionCount);
            keyValue.accept("Last statistics reset", APIServlet.toString((ZonedDateTime)storageStats.storageStatistics().lastStatisticsReset));
            float sizeInMB = (float)storageStats.storageStatistics.storageSizeInBytes / 1048576.0f;
            keyValue.accept("On-disk storage (MB)", new DecimalFormat("######0.0#").format(sizeInMB));
            keyValue.accept("HTTP requests (current hour)", storageStats.httpStats.getCountForCurrentHour());
            keyValue.accept("HTTP requests (last 24 hours)", storageStats.httpStats.getCountForLast24Hours());
            keyValue.accept("Last meta-data fetch success", storageStats.storageStatistics().mostRecentSuccess().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Last meta-data fetch failure", storageStats.storageStatistics().mostRecentFailure().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Last meta-data fetch requested", storageStats.storageStatistics().mostRecentRequested().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Storage item reads (most recent)", storageStats.storageStatistics().reads.getMostRecentAccess().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Storage item reads (current hour)", storageStats.storageStatistics().reads.getCountForCurrentHour());
            keyValue.accept("Storage item reads (last 24h)", storageStats.storageStatistics().reads.getCountForLast24Hours());
            keyValue.accept("Storage item writes (most recent)", storageStats.storageStatistics().writes.getMostRecentAccess().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Storage item writes (current hour)", storageStats.storageStatistics().writes.getCountForCurrentHour() + "\n");
            keyValue.accept("Storage item writes (last 24h)", storageStats.storageStatistics().writes.getCountForLast24Hours() + "\n");
            IVersionProvider.Statistics mavenCentralAPIStats = impl.getVersionTracker().getVersionProvider().getStatistics();
            keyValue.accept("Maven Central API calls (most recent)", mavenCentralAPIStats.apiRequests.getMostRecentAccess().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Maven Central API calls (current hour)", mavenCentralAPIStats.apiRequests.getCountForCurrentHour() + "\n");
            keyValue.accept("Maven Central API calls (last 24h)", mavenCentralAPIStats.apiRequests.getCountForLast24Hours() + "\n");
            List<String> apiCallsByStatusCode = mavenCentralAPIStats.httpRequestCountByResponseCode.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(entry -> {
                int httpStatusCode = (Integer)entry.getKey();
                String color = switch (httpStatusCode) {
                    case 200 -> "green";
                    case 404 -> "orange";
                    default -> "red";
                };
                String template = "HTTP <span style=\"color: %s\">%d</span> =&gt; %d";
                return "HTTP <span style=\"color: %s\">%d</span> =&gt; %d".formatted(color, httpStatusCode, entry.getValue());
            }).toList();
            keyValue.accept("Maven Central API calls by HTTP status code", String.join((CharSequence)"<br/>", apiCallsByStatusCode));
            keyValue.accept("Repo metadata fetch (most recent)", mavenCentralAPIStats.metaDataRequests.getMostRecentAccess().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Repo metadata fetches (current hour)", mavenCentralAPIStats.metaDataRequests.getCountForCurrentHour() + "\n");
            keyValue.accept("Repo metadata fetches (last 24h)", mavenCentralAPIStats.metaDataRequests.getCountForLast24Hours() + "\n");
            IBackgroundUpdater.Statistics bgStats = impl.getBackgroundUpdater().getStatistics();
            keyValue.accept("Background update (most recent)", bgStats.scheduledUpdates.getMostRecentAccess().map(APIServlet::toString).orElse("n/a"));
            keyValue.accept("Background updates (current hour)", bgStats.scheduledUpdates.getCountForCurrentHour() + "\n");
            keyValue.accept("Background updates (last 24h)", bgStats.scheduledUpdates.getCountForLast24Hours() + "\n");
            String baseURL = this.getServletContext().getContextPath();
            this.sendFileFromClasspath("/markup/page.html", resp, "text/html", Map.of("baseUrl", baseURL, "tableContent", fragments.toString()));
        }
        resp.getWriter().flush();
    }

    private static void redirectToHomePage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String scheme = req.getScheme();
        String host = req.getServerName();
        int serverPort = req.getServerPort();
        String servletPath = req.getContextPath();
        boolean isWellKnownPort = serverPort == 80 || serverPort == 443;
        String home = isWellKnownPort ? "%s://%s/%s".formatted(scheme, host, servletPath) : "%s://%s:%d/%s".formatted(scheme, host, serverPort, servletPath);
        resp.sendRedirect(home);
    }

    private static String resolvePlaceholders(String input, Map<String, String> placeholderValues) {
        String source = input;
        HashSet<String> keys = new HashSet<String>();
        Matcher m = PLACEHOLDER_PATTERN.matcher(source);
        while (m.find()) {
            keys.add(m.group(1));
        }
        for (String key : keys) {
            if (!placeholderValues.containsKey(key)) {
                throw new RuntimeException("Unknown placeholder '" + key + "'");
            }
            String value = placeholderValues.get(key);
            if (value == null) {
                throw new RuntimeException("NULL value for placeholder '" + key + "' is not supported");
            }
            source = source.replace("${" + key + "}", value);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RequestsPerHour requestsPerHour = this.requestsPerHour;
        synchronized (requestsPerHour) {
            this.requestsPerHour.update();
        }
        ServletInputStream in = req.getInputStream();
        ByteArrayOutputStream reqData = new ByteArrayOutputStream();
        IAPIClient.Protocol protocol = null;
        try {
            int protoId = in.read();
            if (protoId == -1) {
                throw new EOFException("Premature end of input, expected protocol ID");
            }
            try {
                protocol = IAPIClient.Protocol.fromByte((byte)((byte)protoId));
            }
            catch (IllegalArgumentException e) {
                String contentType = req.getHeader("Content-Type");
                if (!"application/json".equals(contentType)) {
                    throw e;
                }
                LOG.info("Client did not send valid protocol ID byte but uses Content-Type: application/json");
                reqData.write(protoId);
                protocol = IAPIClient.Protocol.JSON;
            }
            byte[] binaryResponse = this.processRequest((InputStream)in, reqData, protocol);
            resp.getOutputStream().write(binaryResponse);
            resp.setStatus(200);
        }
        catch (Exception e) {
            String body;
            if (protocol == null || reqData.toByteArray().length == 0) {
                body = Utils.toHex((byte[])reqData.toByteArray());
            } else {
                switch (1.$SwitchMap$de$codesourcery$versiontracker$client$api$IAPIClient$Protocol[protocol.ordinal()]) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 1: {
                        String string = reqData.toString(StandardCharsets.UTF_8);
                        break;
                    }
                    case 2: {
                        String string = body = Utils.toHex((byte[])reqData.toByteArray());
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.error("doPost(): Caught ", (Throwable)e);
                LOG.error("doPost(): BODY = \n=============\n" + body + "\n================");
            } else {
                LOG.error("doPost(): Caught " + e.getMessage() + " from " + req.getRemoteAddr(), (Throwable)e);
            }
            resp.sendError(400, "Internal error: " + e.getMessage());
        }
    }

    public byte[] processRequest(InputStream in, ByteArrayOutputStream reqData, IAPIClient.Protocol protocol) throws Exception {
        int len;
        byte[] buffer = new byte[10240];
        while ((len = in.read(buffer)) > 0) {
            reqData.write(buffer, 0, len);
        }
        return switch (1.$SwitchMap$de$codesourcery$versiontracker$client$api$IAPIClient$Protocol[protocol.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> this.processRequest(reqData.toByteArray());
            case 1 -> {
                String body = reqData.toString(StandardCharsets.UTF_8);
                String responseJSON = this.processRequest(body);
                yield responseJSON.getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    public byte[] processRequest(byte[] requestData) throws Exception {
        BinarySerializer.IBuffer inBuffer = BinarySerializer.IBuffer.wrap((byte[])requestData);
        BinarySerializer inSerializer = new BinarySerializer(inBuffer);
        APIRequest apiRequest = APIRequest.deserialize((BinarySerializer)inSerializer);
        switch (1.$SwitchMap$de$codesourcery$versiontracker$common$APIRequest$Command[apiRequest.command.ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
        }
        QueryRequest query = (QueryRequest)apiRequest;
        QueryResponse response = this.processQuery(query);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinarySerializer.IBuffer outBuffer = BinarySerializer.IBuffer.wrap((OutputStream)byteArrayOutputStream);
        BinarySerializer outSerializer = new BinarySerializer(outBuffer);
        response.serialize(outSerializer, query.clientVersion.serializationFormat);
        return byteArrayOutputStream.toByteArray();
    }

    public String processRequest(String jsonRequest) throws Exception {
        APIRequest apiRequest = APIServlet.parse((String)jsonRequest, (ObjectMapper)JSON_MAPPER);
        switch (1.$SwitchMap$de$codesourcery$versiontracker$common$APIRequest$Command[apiRequest.command.ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
        }
        QueryResponse response = this.processQuery((QueryRequest)apiRequest);
        return JSON_MAPPER.writeValueAsString((Object)response);
    }

    public static APIRequest parse(String json, ObjectMapper mapper) throws Exception {
        APIRequest apiRequest = JSONHelper.parseAPIRequest((String)json, (ObjectMapper)mapper);
        switch (1.$SwitchMap$de$codesourcery$versiontracker$common$APIRequest$Command[apiRequest.command.ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
        }
        return (QueryRequest)mapper.readValue(json, QueryRequest.class);
    }

    private QueryResponse processQuery(QueryRequest request) throws InterruptedException {
        BiPredicate<VersionInfo, Artifact> requiresUpdate;
        QueryResponse result = new QueryResponse();
        result.serverVersion = switch (1.$SwitchMap$de$codesourcery$versiontracker$common$ClientVersion[request.clientVersion.ordinal()]) {
            case 1 -> ServerVersion.V1;
            default -> ServerVersion.latest();
        };
        APIImpl impl = APIImplHolder.getInstance().getImpl();
        if (this.artifactUpdatesEnabled) {
            IBackgroundUpdater updater = impl.getBackgroundUpdater();
            requiresUpdate = (arg_0, arg_1) -> ((IBackgroundUpdater)updater).requiresUpdate(arg_0, arg_1);
        } else {
            requiresUpdate = (optVersionInfo, art) -> false;
        }
        Map results = impl.getVersionTracker().getVersionInfo(request.artifacts, requiresUpdate);
        for (Artifact artifact : request.artifacts) {
            VersionInfo info = (VersionInfo)results.get(artifact);
            ArtifactResponse x = new ArtifactResponse();
            result.artifacts.add(x);
            x.artifact = artifact;
            x.updateAvailable = ArtifactResponse.UpdateAvailable.NOT_FOUND;
            if (info == null || !info.hasVersions()) continue;
            if (artifact.hasReleaseVersion()) {
                versions = info.getVersionsSortedDescending(Artifact::isReleaseVersion, request.blacklist);
                if (!versions.isEmpty()) {
                    if (versions.size() > 1) {
                        x.secondLatestVersion = (Version)versions.get(1);
                    }
                    x.latestVersion = (Version)versions.get(0);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("processQuery(): latest release version from metadata: " + info.latestReleaseVersion);
                        LOG.debug("processQuery(): Calculated latest release version: " + x.latestVersion);
                    }
                    if (!Objects.equals(x.latestVersion, info.latestReleaseVersion)) {
                        LOG.warn("processQuery(): Artifact " + info.artifact + " - latest release by date: " + x.latestVersion + ", latest according to meta data: " + info.latestReleaseVersion);
                    }
                }
            } else {
                versions = info.getVersionsSortedDescending(Artifact::isSnapshotVersion, request.blacklist);
                if (!versions.isEmpty()) {
                    if (versions.size() > 1) {
                        x.secondLatestVersion = (Version)versions.get(1);
                    }
                    x.latestVersion = (Version)versions.get(0);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("processQuery(): latest release version from metadata: " + info.latestSnapshotVersion);
                        LOG.debug("processQuery(): Calculated latest snapshot version: " + x.latestVersion);
                    }
                    if (!Objects.equals(x.latestVersion, info.latestSnapshotVersion)) {
                        LOG.warn("processQuery(): Artifact " + info.artifact + " - latest SNAPSHOT release by date: " + x.latestVersion + ", latest SNAPSHOT release according to meta data: " + info.latestSnapshotVersion);
                    }
                }
            }
            if (artifact.version == null || x.latestVersion == null) {
                x.updateAvailable = ArtifactResponse.UpdateAvailable.MAYBE;
            } else {
                Optional currentVersion = info.getVersion(artifact.version);
                currentVersion.ifPresent(version -> {
                    x.currentVersion = version;
                });
                int cmp = Artifact.VERSION_COMPARATOR.compare(artifact.version, x.latestVersion.versionString);
                x.updateAvailable = cmp >= 0 ? ArtifactResponse.UpdateAvailable.NO : ArtifactResponse.UpdateAvailable.YES;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("processQuery(): " + artifact + " <-> " + x.latestVersion + " => " + x.updateAvailable);
        }
        return result;
    }

    public void setArtifactUpdatesEnabled(boolean artifactUpdatesEnabled) {
        this.artifactUpdatesEnabled = artifactUpdatesEnabled;
    }

    private Optional<String> getApplicationVersion() {
        return this.readKeyValue("/META-INF/maven/de.codesourcery.versiontracker/versiontracker-server/pom.properties", '=', "version");
    }

    private Optional<String> getSHA1Hash() {
        return this.readKeyValue("/META-INF/MANIFEST.MF", ':', "git-SHA-1");
    }

    private Optional<String> readKeyValue(String classpathLocation, char separator, String key) {
        try {
            return this.readLines(classpathLocation).map(line -> {
                String[] parts = line.split(Pattern.quote(Character.toString(separator)));
                return Optional.ofNullable(parts.length > 1 && key.equals(parts[0]) ? parts[1] : null);
            }).flatMap(Optional::stream).findFirst();
        }
        catch (Exception e) {
            LOG.error("getSHA1Hash(): Failed to get '" + key + "' from " + classpathLocation, (Throwable)(LOG.isDebugEnabled() ? e : null));
            return Optional.empty();
        }
    }

    private Stream<String> readLines(String classpathLocation) throws IOException {
        try (InputStream inStream = this.getServletContext().getResourceAsStream(classpathLocation);){
            if (inStream != null) {
                String s = new String(inStream.readAllBytes(), StandardCharsets.UTF_8);
                Stream<String> stream = Arrays.stream(s.split("\n"));
                return stream;
            }
        }
        return Stream.empty();
    }
}

