/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.enforcerrule;

import de.codesourcery.versiontracker.client.api.IAPIClient;
import de.codesourcery.versiontracker.client.api.local.LocalAPIClient;
import de.codesourcery.versiontracker.client.api.remote.RemoteApiClient;
import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.ArtifactResponse;
import de.codesourcery.versiontracker.common.Blacklist;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.xsd.IgnoreVersion;
import de.codesourcery.versiontracker.xsd.Rule;
import de.codesourcery.versiontracker.xsd.Ruleset;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.project.MavenProject;

@Named(value="dependencyAgeRule")
public class DependencyAgeRule
extends AbstractEnforcerRule {
    private static final String MAX_AGE_PATTERN_STRING = "(\\d+)\\s*([dwmy]|(day|days|week|weeks|month|months|year|years))";
    public static final Pattern MAX_AGE_PATTERN = Pattern.compile("(\\d+)\\s*([dwmy]|(day|days|week|weeks|month|months|year|years))", 2);
    private static final Object GLOBAL_LOCK = new Object();
    private static final Map<String, RemoteApiClient> CLIENTS = new HashMap<String, RemoteApiClient>();
    private static final Object LOCAL_API_CLIENT_LOCK = new Object();
    private static LocalAPIClient LOCAL_API_CLIENT;
    private static final JAXBContext jaxbContext;
    private MavenProject project;
    Age parsedMaxAge;
    Age parsedWarnAge;
    String warnAge;
    String maxAge;
    String apiEndpoint;
    boolean verbose;
    boolean debug;
    File rulesFile;
    boolean failOnMissingArtifacts = true;
    boolean binaryProtocol = true;
    boolean searchRulesInParentDirectories;

    private Optional<ZonedDateTime> getReleaseDate(Version v) {
        return Optional.ofNullable(v.releaseDate).or(() -> Optional.ofNullable(v.firstSeenByServer));
    }

    private ThresholdCheckResponse isTooOld(String thresholdName, ArtifactResponse response, Age threshold) {
        if (response.hasCurrentVersion() && response.hasLatestVersion()) {
            Optional<ZonedDateTime> currentVersionReleaseDate = this.getReleaseDate(response.currentVersion);
            Optional<ZonedDateTime> latestVersionReleaseDate = this.getReleaseDate(response.latestVersion);
            if (currentVersionReleaseDate.isPresent() && latestVersionReleaseDate.isPresent() && !Version.sameVersionNumber((Version)response.currentVersion, (Version)response.latestVersion) && currentVersionReleaseDate.get().compareTo(latestVersionReleaseDate.get()) <= 0) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Using outdated " + response.currentVersion + " of " + response.artifact + " , latest is " + response.latestVersion));
                }
                ZonedDateTime now = this.currentTime();
                if (response.secondLatestVersion != null && Version.sameVersionNumber((Version)response.currentVersion, (Version)response.secondLatestVersion)) {
                    Duration age;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(thresholdName + ": We're on the second-latest version."));
                    }
                    if (threshold.isExceeded(age = Duration.between(latestVersionReleaseDate.get(), now), now)) {
                        this.getLog().debug((CharSequence)(thresholdName + " threshold (I) exceeded for " + response.artifact + ", age is " + DependencyAgeRule.formatDuration(age) + " but threshold is " + threshold));
                        return new ThresholdCheckResponse(true, threshold, age);
                    }
                    return ThresholdCheckResponse.thresholdNotExceeded(threshold, age);
                }
                Duration age = Duration.between(currentVersionReleaseDate.get(), now);
                if (threshold.isExceeded(age, now)) {
                    this.getLog().debug((CharSequence)(thresholdName + " threshold (II) exceeded for " + response.artifact + ", age is " + DependencyAgeRule.formatDuration(age) + " but threshold is " + threshold));
                    return new ThresholdCheckResponse(true, threshold, age);
                }
                return ThresholdCheckResponse.thresholdNotExceeded(threshold, age);
            }
            if (!response.currentVersion.hasReleaseDate()) {
                this.getLog().warn((CharSequence)("Unable to determine current release date for version '" + response.currentVersion.versionString + "' of " + response.artifact));
            }
            if (!response.latestVersion.hasReleaseDate()) {
                this.getLog().warn((CharSequence)("Unable to determine latest release date for version '" + response.latestVersion.versionString + "' of " + response.artifact));
            }
        }
        return ThresholdCheckResponse.thresholdNotExceeded(threshold, Duration.ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws EnforcerRuleException {
        long start = System.currentTimeMillis();
        try {
            this.executeInternal();
        }
        finally {
            if (this.debug) {
                long elapsed = System.currentTimeMillis() - start;
                this.getLog().info((CharSequence)("RULE TIME: " + elapsed + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInternal() throws EnforcerRuleException {
        this.setup();
        if (StringUtils.isBlank((CharSequence)this.apiEndpoint)) {
            Object object = GLOBAL_LOCK;
            synchronized (object) {
                this.doExecute();
            }
        } else {
            this.doExecute();
        }
    }

    private void setup() throws EnforcerRuleException {
        ZonedDateTime now;
        if (StringUtils.isNotBlank((CharSequence)this.maxAge)) {
            this.parsedMaxAge = this.parseAge("maxAge", this.maxAge);
        }
        if (StringUtils.isNotBlank((CharSequence)this.warnAge)) {
            this.parsedWarnAge = this.parseAge("warnAge", this.warnAge);
        }
        if (this.parsedWarnAge == null && this.parsedMaxAge == null) {
            this.fail("Configuration error - at least one of 'maxAge' or 'warnAge' needs to be set");
        }
        if (this.parsedWarnAge != null && this.parsedMaxAge != null && (now = ZonedDateTime.now()).plus(this.parsedWarnAge.toPeriod()).isAfter(now.plus(this.parsedMaxAge.toPeriod()))) {
            this.fail("Configuration error - 'warnAge' needs to be less than 'maxAge'");
        }
        this.getLog().debug((CharSequence)("==== Rule executing with API endpoint = " + this.apiEndpoint));
        if (this.parsedWarnAge != null) {
            this.getLog().debug((CharSequence)("==== Rule executing with warnAge = " + this.parsedWarnAge));
        }
        if (this.parsedMaxAge != null) {
            this.getLog().debug((CharSequence)("==== Rule executing with maxAge = " + this.parsedMaxAge));
        }
    }

    private void doExecute() throws EnforcerRuleException {
        Set mavenArtifacts = this.project.getDependencyArtifacts();
        if (!mavenArtifacts.isEmpty()) {
            List result;
            IAPIClient client;
            Blacklist bl;
            try {
                bl = this.loadBlacklist();
            }
            catch (JAXBException | ParseException e1) {
                this.fail("Failed to parse rules.xml (" + e1.getMessage() + ")", e1);
                throw new RuntimeException("Unreachable code reached");
            }
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            for (org.apache.maven.artifact.Artifact ma : mavenArtifacts) {
                Artifact a = new Artifact();
                a.groupId = ma.getGroupId();
                a.artifactId = ma.getArtifactId();
                a.version = ma.getVersion();
                a.type = ma.getType();
                a.setClassifier(ma.getClassifier());
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Project depends on " + a));
                } else {
                    this.getLog().debug((CharSequence)("Project depends on " + a));
                }
                if (bl == null || !bl.isAllVersionsBlacklisted(a.groupId, a.artifactId) && !bl.isVersionBlacklisted(a.groupId, a.artifactId, a.version)) {
                    artifacts.add(a);
                    continue;
                }
                if (!this.verbose) continue;
                this.getLog().warn((CharSequence)("Artifact ignored because of blacklist: " + a));
            }
            if (StringUtils.isBlank((CharSequence)this.apiEndpoint)) {
                this.getLog().warn((CharSequence)"No API endpoint configured, running locally");
                client = this.getLocalAPIClient(this.debug);
            } else {
                IAPIClient.Protocol protocol;
                IAPIClient.Protocol protocol2 = protocol = this.binaryProtocol ? IAPIClient.Protocol.BINARY : IAPIClient.Protocol.JSON;
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Using " + protocol + " protocol"));
                }
                client = this.getRemoteAPIClient(this.apiEndpoint, protocol, this.debug);
            }
            try {
                if (StringUtils.isBlank((CharSequence)this.apiEndpoint)) {
                    this.getLog().info((CharSequence)("Querying metadata for " + artifacts.size() + " artifacts"));
                } else {
                    this.getLog().info((CharSequence)("Querying metadata for " + artifacts.size() + " artifacts from " + this.apiEndpoint));
                }
                result = client.query(artifacts, bl);
            }
            catch (Exception e) {
                this.fail("Failed to query version information from '" + this.apiEndpoint + "': " + e.getMessage(), e);
                throw new RuntimeException("Unreachable code reached");
            }
            boolean failBecauseAgeExceeded = false;
            boolean artifactsNotFound = false;
            Duration largestWarningThresholdViolation = null;
            for (ArtifactResponse artifact : result) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Response from server: " + artifact));
                }
                if (artifact.updateAvailable == ArtifactResponse.UpdateAvailable.NOT_FOUND) {
                    artifactsNotFound = true;
                    this.getLog().warn((CharSequence)("Failed to find metadata for artifact " + artifact.artifact));
                    continue;
                }
                ThresholdCheckResponse maxAgeExceeded = this.parsedMaxAge != null ? this.isTooOld("maxAge", artifact, this.parsedMaxAge) : ThresholdCheckResponse.thresholdNotExceeded(null, Duration.ZERO);
                ThresholdCheckResponse warnAgeExceeded = this.parsedWarnAge != null ? this.isTooOld("warnAge", artifact, this.parsedWarnAge) : ThresholdCheckResponse.thresholdNotExceeded(null, Duration.ZERO);
                failBecauseAgeExceeded |= maxAgeExceeded.thresholdExceeded;
                if (warnAgeExceeded.thresholdExceeded && !maxAgeExceeded.thresholdExceeded) {
                    this.printMessage(artifact, false);
                    Duration age = warnAgeExceeded.actualAge;
                    if (largestWarningThresholdViolation == null || age.compareTo(largestWarningThresholdViolation) > 0) {
                        largestWarningThresholdViolation = age;
                    }
                }
                if (!maxAgeExceeded.thresholdExceeded) continue;
                this.printMessage(artifact, true);
            }
            if (failBecauseAgeExceeded) {
                this.fail("One or more dependencies of this project are older than the allowed maximum age (" + this.parsedMaxAge + ")");
            }
            if (artifactsNotFound && this.failOnMissingArtifacts) {
                this.fail("Failed to find metadata for one or more dependencies of this project");
            }
            if (largestWarningThresholdViolation != null && this.parsedMaxAge != null) {
                ZonedDateTime now = ZonedDateTime.now();
                Period maxPeriod = this.parsedMaxAge.toPeriod();
                Temporal t2 = maxPeriod.subtractFrom(now);
                Duration maxDuration = Duration.between(t2, now);
                Duration remainingTime = maxDuration.minus(largestWarningThresholdViolation);
                ZonedDateTime failureTime = now.plus(remainingTime);
                long millis = remainingTime.toMillis();
                DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.LONG);
                this.getLog().warn((CharSequence)"===========================================");
                this.getLog().warn((CharSequence)("= Your build will likely start FAILING on " + formatter.format(failureTime) + " which is in " + DurationFormatUtils.formatDurationWords((long)millis, (boolean)true, (boolean)true)));
                this.getLog().warn((CharSequence)"===========================================");
            }
        }
    }

    private void printMessage(ArtifactResponse resp, boolean printAsError) {
        String fmt = "Artifact {0} is too old, current version {1} was released on {2} but latest version  is {3} which was released on {4}";
        String msg = MessageFormat.format("Artifact {0} is too old, current version {1} was released on {2} but latest version  is {3} which was released on {4}", resp.artifact.toString(), resp.currentVersion.versionString, DependencyAgeRule.prettyPrint(resp.currentVersion.releaseDate), resp.latestVersion.versionString, DependencyAgeRule.prettyPrint(resp.latestVersion.releaseDate));
        if (printAsError) {
            this.getLog().error((CharSequence)msg);
        } else {
            this.getLog().warn((CharSequence)msg);
        }
    }

    private void fail(String msg, Throwable t) throws EnforcerRuleException {
        this.getLog().error((CharSequence)msg);
        throw new EnforcerRuleException(msg, t);
    }

    private void fail(String msg) throws EnforcerRuleException {
        this.getLog().error((CharSequence)msg);
        throw new EnforcerRuleException(msg);
    }

    private static String prettyPrint(ZonedDateTime dt) {
        if (dt == null) {
            return "n/a";
        }
        ZonedDateTime converted = dt.withZoneSameInstant(ZoneId.systemDefault());
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.LONG).format(converted);
    }

    private Age parseAge(String configKey, String configValue) throws EnforcerRuleException {
        Validate.notBlank((CharSequence)configKey, (String)"configKey must not be null or blank", (Object[])new Object[0]);
        Validate.notNull((Object)configValue, (String)"configValue must not be null", (Object[])new Object[0]);
        try {
            Matcher m = MAX_AGE_PATTERN.matcher(configValue.trim());
            if (m.matches()) {
                int value = Integer.parseInt(m.group(1));
                if (value < 0) {
                    String message = "'" + configKey + "' must be >= 0 but was " + value;
                    this.getLog().error((CharSequence)message);
                    throw new EnforcerRuleException(message);
                }
                AgeUnit unit = AgeUnit.parse(m.group(2));
                return new Age(value, unit);
            }
            String message = "Configuration error - not a valid '" + configKey + "' pattern: '" + configValue + "', must match regex '(\\d+)\\s*([dwmy]|(day|days|week|weeks|month|months|year|years))'";
            this.getLog().error((CharSequence)message);
            throw new EnforcerRuleException(message);
        }
        catch (EnforcerRuleException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Configuration error - not a valid '" + configKey + "' pattern: '" + configValue + "', must match regex '(\\d+)\\s*([dwmy]|(day|days|week|weeks|month|months|year|years))'";
            this.getLog().error((CharSequence)message);
            throw new EnforcerRuleException(message, e);
        }
    }

    public String getCacheId() {
        return this.warnAge + this.apiEndpoint + this.verbose + this.debug + this.rulesFile + this.maxAge;
    }

    private static File getParent(File file) {
        return file.getParentFile();
    }

    private Blacklist loadBlacklist() throws JAXBException, ParseException, EnforcerRuleException {
        List<Rule> rules;
        if (this.rulesFile == null) {
            return null;
        }
        if (!this.rulesFile.exists() && this.searchRulesInParentDirectories) {
            File folder;
            if (this.verbose) {
                this.getLog().info((CharSequence)("Rules file " + this.rulesFile.getAbsolutePath() + " does not exist, searching parent folders"));
            }
            String fileName = this.rulesFile.getName();
            do {
                folder = DependencyAgeRule.getParent(this.rulesFile.getParentFile());
                this.rulesFile = new File(folder, fileName);
                if (!this.debug) continue;
                this.getLog().info((CharSequence)("Trying " + this.rulesFile.getAbsolutePath()));
            } while ((!this.rulesFile.exists() || !this.rulesFile.isFile()) && folder != null && folder.toPath().getNameCount() != 0);
        }
        if (!this.rulesFile.exists() || !this.rulesFile.isFile()) {
            this.fail(this.rulesFile.getAbsolutePath() + " does not exist or is no regular file");
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("Using XML rules file " + this.rulesFile.getAbsolutePath()));
        }
        Blacklist blacklist = new Blacklist();
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        Ruleset result = (Ruleset)jaxbUnmarshaller.unmarshal(this.rulesFile);
        this.assertSupportedComparisonMethod(result.getComparisonMethod());
        List<Rule> list = rules = result.getRules() != null ? result.getRules().getRule() : null;
        if (rules != null) {
            for (Rule r : rules) {
                boolean hasIgnoredVersions;
                this.assertSupportedComparisonMethod(r.getComparisonMethod());
                boolean bl = hasIgnoredVersions = r.getIgnoreVersions() != null && r.getIgnoreVersions().getIgnoreVersion() != null;
                if (hasIgnoredVersions) {
                    this.assertMatcherTypeSupported(r.getIgnoreVersions().getIgnoreVersion());
                }
                if (hasIgnoredVersions && StringUtils.isBlank((CharSequence)r.getArtifactId())) {
                    for (IgnoreVersion v : r.getIgnoreVersions().getIgnoreVersion()) {
                        blacklist.addIgnoredVersion(r.getGroupId(), v.getValue(), Blacklist.VersionMatcher.fromString((String)v.getType()));
                    }
                    continue;
                }
                if (!hasIgnoredVersions) continue;
                for (IgnoreVersion v : r.getIgnoreVersions().getIgnoreVersion()) {
                    blacklist.addIgnoredVersion(r.getGroupId(), r.getArtifactId(), v.getValue(), Blacklist.VersionMatcher.fromString((String)v.getType()));
                }
            }
        }
        if (result.getIgnoreVersions() != null) {
            this.assertMatcherTypeSupported(result.getIgnoreVersions().getIgnoreVersion());
        }
        if (result.getIgnoreVersions() != null && result.getIgnoreVersions().getIgnoreVersion() != null) {
            for (IgnoreVersion v : result.getIgnoreVersions().getIgnoreVersion()) {
                blacklist.addIgnoredVersion(v.getValue(), Blacklist.VersionMatcher.fromString((String)v.getType()));
            }
        }
        return blacklist;
    }

    private void assertMatcherTypeSupported(List<IgnoreVersion> list) throws ParseException {
        if (list != null) {
            for (IgnoreVersion v : list) {
                String matcher = v.getType();
                if (matcher == null || matcher.equals("regex") | matcher.equals("exact")) continue;
                throw new ParseException("Sorry, rules file " + this.rulesFile.getAbsolutePath() + " contains unsupported value '" + matcher + "'for 'type' attribute of <ignoreVersion/> tag", -1);
            }
        }
    }

    private void assertSupportedComparisonMethod(String method) throws ParseException {
        if (method != null && !method.equals("maven")) {
            throw new ParseException("Sorry, rules file " + this.rulesFile.getAbsolutePath() + " contains custom comparison method '" + method + "' but custom comparison methods are not supported by this plugin.", -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAPIClient getLocalAPIClient(boolean debug) {
        Object object = LOCAL_API_CLIENT_LOCK;
        synchronized (object) {
            if (LOCAL_API_CLIENT == null) {
                LOCAL_API_CLIENT = new LocalAPIClient();
                LOCAL_API_CLIENT.setDebugMode(debug);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    Object object = LOCAL_API_CLIENT_LOCK;
                    synchronized (object) {
                        try {
                            LOCAL_API_CLIENT.close();
                        }
                        catch (Exception e) {
                            this.getLog().debug((CharSequence)("Caught exception during close(): " + e.getMessage()));
                        }
                        finally {
                            LOCAL_API_CLIENT = null;
                        }
                    }
                }));
            }
            return LOCAL_API_CLIENT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAPIClient getRemoteAPIClient(String endpoint, IAPIClient.Protocol protocol, boolean debug) {
        String key = endpoint + protocol.name() + debug;
        String callingThreadName = Thread.currentThread().getName();
        Map<String, RemoteApiClient> map = CLIENTS;
        synchronized (map) {
            RemoteApiClient existing = CLIENTS.get(key);
            if (existing == null) {
                existing = new RemoteApiClient(endpoint, protocol);
                existing.setDebugMode(debug);
                CLIENTS.put(key, existing);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (debug) {
                        this.getLog().info((CharSequence)("Shutting down HTTP client acquired by " + callingThreadName + " connecting to " + endpoint + " using " + protocol));
                    }
                    Map<String, RemoteApiClient> map = CLIENTS;
                    synchronized (map) {
                        RemoteApiClient client = CLIENTS.get(key);
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Exception e) {
                                this.getLog().debug((CharSequence)("Caught exception during close(): " + e.getMessage()));
                            }
                            finally {
                                CLIENTS.remove(key);
                            }
                        }
                    }
                }));
            }
            return existing;
        }
    }

    protected ZonedDateTime currentTime() {
        return ZonedDateTime.now();
    }

    @Inject
    public void setProject(MavenProject project) {
        this.project = project;
    }

    private static String formatDuration(Duration duration) {
        return DurationFormatUtils.formatDurationWords((long)duration.toMillis(), (boolean)true, (boolean)true);
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Ruleset.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private record Age(int value, AgeUnit unit) {
        public Period toPeriod() {
            return switch (this.unit) {
                default -> throw new IncompatibleClassChangeError();
                case AgeUnit.DAYS -> Period.ofDays(this.value);
                case AgeUnit.MONTHS -> Period.ofMonths(this.value);
                case AgeUnit.WEEKS -> Period.ofWeeks(this.value);
                case AgeUnit.YEARS -> Period.ofYears(this.value);
            };
        }

        @Override
        public String toString() {
            boolean plural = this.value > 1;
            return switch (this.unit) {
                default -> throw new IncompatibleClassChangeError();
                case AgeUnit.DAYS -> this.value + " " + (plural ? "days" : "day");
                case AgeUnit.MONTHS -> this.value + " " + (plural ? "months" : "month");
                case AgeUnit.WEEKS -> this.value + " " + (plural ? "weeks" : "week");
                case AgeUnit.YEARS -> this.value + " " + (plural ? "years" : "year");
            };
        }

        public boolean isExceeded(Duration elapsed, ZonedDateTime now) {
            Duration threshold = Duration.between(now, now.plus(this.toPeriod()));
            return elapsed.compareTo(threshold) > 0;
        }
    }

    private static final class ThresholdCheckResponse {
        public final Age threshold;
        public final boolean thresholdExceeded;
        public final Duration actualAge;

        public ThresholdCheckResponse(boolean thresholdExceeded, Age threshold, Duration actualAge) {
            if (thresholdExceeded) {
                Validate.isTrue((threshold != null ? 1 : 0) != 0, (String)"threshold must not be null", (Object[])new Object[0]);
                Validate.isTrue((actualAge != null ? 1 : 0) != 0, (String)"actualAge must not be null", (Object[])new Object[0]);
            }
            this.thresholdExceeded = thresholdExceeded;
            this.threshold = threshold;
            this.actualAge = actualAge;
        }

        public static ThresholdCheckResponse thresholdNotExceeded(Age threshold, Duration actualAge) {
            return new ThresholdCheckResponse(false, threshold, actualAge);
        }
    }

    private static enum AgeUnit {
        DAYS,
        WEEKS,
        MONTHS,
        YEARS;


        public static AgeUnit parse(String unit) {
            if (StringUtils.isBlank((CharSequence)unit)) {
                throw new IllegalArgumentException("age unit must not be NULL/blank");
            }
            String s = unit.trim().toLowerCase();
            if ("d".equals(s) || "day".equals(s) || "days".equals(s)) {
                return DAYS;
            }
            if ("w".equals(s) || "week".equals(s) || "weeks".equals(s)) {
                return WEEKS;
            }
            if ("m".equals(s) || "month".equals(s) || "months".equals(s)) {
                return MONTHS;
            }
            if ("y".equals(s) || "year".equals(s) || "years".equals(s)) {
                return YEARS;
            }
            throw new IllegalArgumentException("Unknown age unit '" + unit + "'");
        }
    }
}

