/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.common.server.MavenCentralVersionProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SonatypeRestAPIUrlBuilder {
    private static final Logger LOG = LogManager.getLogger(SonatypeRestAPIUrlBuilder.class);
    private static final int DEFAULT_MAX_RESULT_COUNT = 300;
    private final Map<InternalParameter, Object> args = new HashMap<InternalParameter, Object>();
    private final String baseURL;

    public SonatypeRestAPIUrlBuilder() {
        this(300);
    }

    public SonatypeRestAPIUrlBuilder(int rowCount) {
        this("https://search.maven.org/solrsearch/select", rowCount);
    }

    public SonatypeRestAPIUrlBuilder(String baseURL) {
        this(baseURL, 300);
    }

    public SonatypeRestAPIUrlBuilder(String baseURL, int maxResultCount) {
        Validate.notBlank((CharSequence)baseURL, (String)"baseURL must not be null or blank", (Object[])new Object[0]);
        Validate.isTrue((maxResultCount > 0 ? 1 : 0) != 0);
        this.baseURL = baseURL;
        this.args.put(InternalParameter.PARAM_MAX_RESULT_COUNT, maxResultCount);
    }

    public SonatypeRestAPIUrlBuilder artifactId(String id) {
        Validate.notBlank((CharSequence)id, (String)"Artifact ID must not be null", (Object[])new Object[0]);
        return this.set(InternalParameter.PARAM_ARTIFACT_ID, id);
    }

    public SonatypeRestAPIUrlBuilder startOffset(int offset) {
        Validate.isTrue((offset >= 0 ? 1 : 0) != 0);
        return this.set(InternalParameter.PARAM_START_OFFSET, offset, false);
    }

    public SonatypeRestAPIUrlBuilder groupId(String id) {
        Validate.notBlank((CharSequence)id, (String)"group ID must not be null or blank", (Object[])new Object[0]);
        return this.set(InternalParameter.PARAM_GROUP_ID, id);
    }

    public SonatypeRestAPIUrlBuilder version(String id) {
        Validate.notBlank((CharSequence)id, (String)"version must not be null or blank", (Object[])new Object[0]);
        return this.set(InternalParameter.PARAM_VERSION, id);
    }

    public SonatypeRestAPIUrlBuilder classifier(String id) {
        if (id != null) {
            this.set(InternalParameter.PARAM_CLASSIFIER, id);
        }
        return this;
    }

    public SonatypeRestAPIUrlBuilder returnAllResults() {
        return this.set(InternalParameter.PARAM_RETURN_ALL_RESULTS, true);
    }

    private SonatypeRestAPIUrlBuilder set(InternalParameter param, Object value) {
        return this.set(param, value, true);
    }

    private SonatypeRestAPIUrlBuilder set(InternalParameter param, Object value, boolean failIfAlreadySet) {
        Validate.notNull((Object)((Object)param), (String)"param must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"value must not be null", (Object[])new Object[0]);
        if (failIfAlreadySet && this.args.containsKey((Object)param)) {
            throw new IllegalStateException("Parameter '" + param + "' already set to '" + this.args.get((Object)param) + "' ? ");
        }
        this.args.put(param, value);
        return this;
    }

    private String getString(InternalParameter param) {
        Validate.notNull((Object)((Object)param), (String)"param must not be null", (Object[])new Object[0]);
        return (String)this.args.get((Object)param);
    }

    private Boolean getBoolean(InternalParameter param) {
        Validate.notNull((Object)((Object)param), (String)"param must not be null", (Object[])new Object[0]);
        return (Boolean)this.args.get((Object)param);
    }

    private Integer getInteger(InternalParameter param) {
        Validate.notNull((Object)((Object)param), (String)"param must not be null", (Object[])new Object[0]);
        return (Integer)this.args.get((Object)param);
    }

    public URL build() throws IOException {
        String groupId = this.getString(InternalParameter.PARAM_GROUP_ID);
        String artifactId = this.getString(InternalParameter.PARAM_ARTIFACT_ID);
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be null or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId must not be null or blank", (Object[])new Object[0]);
        HashMap<MavenCentralVersionProvider.HttpParam, String> params = new HashMap<MavenCentralVersionProvider.HttpParam, String>();
        String query = "g:" + groupId + " AND a:" + artifactId;
        String classifier = this.getString(InternalParameter.PARAM_CLASSIFIER);
        if (StringUtils.isNotBlank((CharSequence)classifier)) {
            query = query + "AND l:" + classifier;
        }
        String version = this.getString(InternalParameter.PARAM_VERSION);
        Boolean returnAllVersions = this.getBoolean(InternalParameter.PARAM_RETURN_ALL_RESULTS);
        if (returnAllVersions != null && returnAllVersions.booleanValue()) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)version), (String)"version must be null or blank when returnAllVersions == true", (Object[])new Object[0]);
            params.put(MavenCentralVersionProvider.HttpParam.OPT_RETURN_ALL_VERSION, null);
        } else {
            Validate.notBlank((CharSequence)version, (String)"version must not be null or blank when returnAllVersions == false", (Object[])new Object[0]);
            query = query + " AND v: " + version;
        }
        params.put(MavenCentralVersionProvider.HttpParam.QUERY, query);
        Integer startOffset = this.getInteger(InternalParameter.PARAM_START_OFFSET);
        if (startOffset != null) {
            params.put(MavenCentralVersionProvider.HttpParam.START_OFFSET, Integer.toString(startOffset));
        }
        int rowCount = this.getInteger(InternalParameter.PARAM_MAX_RESULT_COUNT);
        params.put(MavenCentralVersionProvider.HttpParam.MAX_RESULT_COUNT, Integer.toString(rowCount));
        params.put(MavenCentralVersionProvider.HttpParam.RESULT_TYPE, "json");
        return this.createURL(params);
    }

    private URL createURL(Map<MavenCentralVersionProvider.HttpParam, String> httpGetParams) throws IOException {
        Validate.notEmpty(httpGetParams);
        String queryString = "?" + httpGetParams.entrySet().stream().sorted(Comparator.comparingInt(a -> ((MavenCentralVersionProvider.HttpParam)((Object)((Object)a.getKey()))).order)).map(x -> {
            String value;
            if (x.getValue() != null) {
                value = (String)x.getValue();
            } else if (((MavenCentralVersionProvider.HttpParam)((Object)((Object)x.getKey()))).value != null) {
                value = ((MavenCentralVersionProvider.HttpParam)((Object)((Object)x.getKey()))).value;
            } else {
                throw new IllegalArgumentException("No value for HTTP get parameter '" + x.getKey() + "'");
            }
            return ((MavenCentralVersionProvider.HttpParam)((Object)((Object)x.getKey()))).literal + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
        }).collect(Collectors.joining("&"));
        String strippedBaseUrl = this.baseURL;
        while (strippedBaseUrl.endsWith("/")) {
            strippedBaseUrl = strippedBaseUrl.substring(0, strippedBaseUrl.length() - 1);
        }
        String urlString = strippedBaseUrl + queryString;
        try {
            return new URI(urlString).toURL();
        }
        catch (URISyntaxException e) {
            LOG.error("getReleaseDateNew(): Invalid URL ? " + urlString, (Throwable)e);
            throw new IOException(e);
        }
    }

    private static enum InternalParameter {
        PARAM_START_OFFSET,
        PARAM_MAX_RESULT_COUNT,
        PARAM_RETURN_ALL_RESULTS,
        PARAM_VERSION,
        PARAM_CLASSIFIER,
        PARAM_ARTIFACT_ID,
        PARAM_GROUP_ID;

    }
}

