/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.ArtifactMap;
import java.util.concurrent.locks.ReentrantLock;

public class SharedLockCache {
    private static final ArtifactMap<ReentrantLock> locks = new ArtifactMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWhileLocked(Artifact artifact, ThrowingRunnable callback) throws Exception, InterruptedException {
        ReentrantLock lock;
        ArtifactMap<ReentrantLock> artifactMap = locks;
        synchronized (artifactMap) {
            lock = locks.get(artifact.groupId, artifact.artifactId);
            if (lock == null) {
                lock = new ReentrantLock(true);
                locks.put(artifact.groupId, artifact.artifactId, lock);
            }
        }
        lock.lockInterruptibly();
        try {
            callback.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

