/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import java.util.HashMap;
import java.util.Map;

public enum SerializationFormat {
    V1(1),
    V2(2),
    V3(3);

    public final short version;

    private SerializationFormat(short version) {
        this.version = version;
        if (Holder.versionsByNumber.put(version, this) != null) {
            throw new IllegalStateException("Duplicate version number: " + version);
        }
    }

    public String toString() {
        return "serialization format V" + this.version;
    }

    public boolean isBefore(SerializationFormat other) {
        return this.version < other.version;
    }

    public boolean isAtLeast(SerializationFormat other) {
        return this.version >= other.version;
    }

    public static SerializationFormat fromVersionNumber(short number) {
        SerializationFormat result = Holder.versionsByNumber.get(number);
        if (result == null) {
            throw new IllegalArgumentException("Unknown serialization format version number: " + number);
        }
        return result;
    }

    public static SerializationFormat latest() {
        SerializationFormat latest = null;
        for (SerializationFormat v : SerializationFormat.values()) {
            if (latest != null && v.version <= latest.version) continue;
            latest = v;
        }
        return latest;
    }

    private static final class Holder {
        public static final Map<Short, SerializationFormat> versionsByNumber = new HashMap<Short, SerializationFormat>();

        private Holder() {
        }
    }
}

