/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.IVersionProvider;
import de.codesourcery.versiontracker.common.JSONHelper;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.common.VersionInfo;
import de.codesourcery.versiontracker.common.server.ConfigurationProvider;
import de.codesourcery.versiontracker.common.server.SonatypeRestAPIUrlBuilder;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MavenCentralVersionProvider
implements IVersionProvider {
    private static final Logger LOG = LogManager.getLogger(MavenCentralVersionProvider.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneId.of("UTC"));
    public static final String DEFAULT_REPO1_BASE_URL = "https://repo1.maven.org/maven2/";
    public static final String DEFAULT_SONATYPE_REST_API_BASE_URL = "https://search.maven.org/solrsearch/select";
    private static final ObjectMapper JSON_MAPPER = JSONHelper.newObjectMapper();
    private final PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
    private final String repo1BaseUrl;
    private final String sonatypeRestApiBaseUrl;
    private final ThreadLocal<MyExpressions> expressions = ThreadLocal.withInitial(MyExpressions::new);
    private final Map<URI, CloseableHttpClient> clients = new HashMap<URI, CloseableHttpClient>();
    private int maxConcurrentThreads = 10;
    private final IVersionProvider.Statistics statistics = new IVersionProvider.Statistics();
    private final Object THREAD_POOL_LOCK = new Object();
    private ThreadPoolExecutor threadPool;
    private ConfigurationProvider configurationProvider;
    private final ThreadFactory threadFactory = new ThreadFactory(){
        private final ThreadGroup threadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "releasedate-request-threads");
        private final AtomicInteger threadId = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.threadGroup, r);
            t.setDaemon(true);
            t.setName("releasedate-request-thread-" + this.threadId.incrementAndGet());
            return t;
        }
    };

    public MavenCentralVersionProvider() {
        this(DEFAULT_REPO1_BASE_URL, DEFAULT_SONATYPE_REST_API_BASE_URL);
        this.connManager.setDefaultMaxPerRoute(10);
        this.connManager.setMaxTotal(20);
    }

    public MavenCentralVersionProvider(String repo1BaseUrl, String sonatypeRestApiBaseUrl) {
        Validate.notBlank((CharSequence)repo1BaseUrl, (String)"repo1BaseUrl must not be null or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)sonatypeRestApiBaseUrl, (String)"sonatypeRestApiBaseUrl must not be null or blank", (Object[])new Object[0]);
        this.repo1BaseUrl = repo1BaseUrl + (repo1BaseUrl.trim().endsWith("/") ? "" : "/");
        this.sonatypeRestApiBaseUrl = sonatypeRestApiBaseUrl;
    }

    @Override
    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        Validate.notNull((Object)configurationProvider, (String)"configurationProvider must not be null", (Object[])new Object[0]);
        this.configurationProvider = configurationProvider;
    }

    public static void main(String[] args) throws IOException {
        ConfigurationProvider configProvider = new ConfigurationProvider();
        Artifact test = new Artifact();
        test.groupId = "org.apache.tomcat";
        test.artifactId = "tomcat";
        VersionInfo data = new VersionInfo();
        data.artifact = test;
        long start = System.currentTimeMillis();
        MavenCentralVersionProvider provider = new MavenCentralVersionProvider();
        provider.setConfigurationProvider(configProvider);
        IVersionProvider.UpdateResult result = provider.update(data, false);
        long end = System.currentTimeMillis();
        System.out.println("TIME: " + (end - start) + " ms");
        System.out.println("RESULT: " + result);
        System.out.println("GOT: " + data);
        System.out.println("VERSION COUNT: " + data.versions.size());
        data.versions.stream().sorted((a, b) -> a.versionString.compareToIgnoreCase(b.versionString)).forEach(x -> System.out.println(x.versionString + " => " + x.releaseDate));
    }

    private boolean isBlacklisted(Artifact a) {
        return this.configurationProvider.getConfiguration().getBlacklist().isAllVersionsBlacklisted(a.groupId, a.artifactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVersionProvider.UpdateResult update(VersionInfo info, boolean force) throws IOException {
        Artifact artifact = info.artifact;
        if (this.isBlacklisted(artifact)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("update(): Not updating blacklisted artifact " + artifact);
            }
            info.lastSuccessDate = ZonedDateTime.now();
            return IVersionProvider.UpdateResult.BLACKLISTED;
        }
        URL url = new URL(this.repo1BaseUrl + MavenCentralVersionProvider.metaDataPath(artifact));
        if (LOG.isDebugEnabled()) {
            LOG.debug("update(): Retrieving metadata for " + info.artifact + " from " + url);
        }
        try {
            Object object = this.statistics;
            synchronized (object) {
                this.statistics.metaDataRequests.update();
            }
            object = this.performGET(url, stream -> {
                String latestReleaseVersion;
                Document document = MavenCentralVersionProvider.parseXML(stream);
                MyExpressions expr = this.expressions.get();
                String lastChangeString = this.readString(expr.lastUpdateDate, document);
                LOG.debug("update(): last repository change = " + lastChangeString);
                ZonedDateTime lastChangeDate = ZonedDateTime.parse(lastChangeString, DATE_FORMATTER);
                ZonedDateTime previousUpdate = info.lastRepositoryUpdate;
                if (previousUpdate != null && previousUpdate.equals(lastChangeDate)) {
                    if (!force) {
                        LOG.debug("update(): No changes on server.");
                        info.lastSuccessDate = ZonedDateTime.now();
                        return IVersionProvider.UpdateResult.NO_CHANGES_ON_SERVER;
                    }
                    LOG.debug("update(): Forced artifact update");
                } else {
                    LOG.debug("update(): Artifact index XML changed on server");
                }
                List<Version> allVersions = this.queryAllVersions(info.artifact);
                info.removeVersionsIf(v -> {
                    boolean remove = allVersions.stream().noneMatch(x -> x.versionString.equals(v.versionString));
                    if (remove) {
                        LOG.warn("update(): Version " + v + " is gone from metadata.xml of " + info.artifact + " ?");
                    }
                    return remove;
                });
                allVersions.forEach(info::addVersion);
                String latestSnapshotVersion = this.readString(expr.latestSnapshot, document);
                if (StringUtils.isNotBlank((CharSequence)latestSnapshotVersion)) {
                    info.getVersion(latestSnapshotVersion).or(() -> Optional.of(new Version(latestSnapshotVersion, null))).ifPresent(x -> {
                        info.latestSnapshotVersion = x;
                    });
                }
                if (StringUtils.isNotBlank((CharSequence)(latestReleaseVersion = this.readString(expr.latestRelease, document)))) {
                    info.getVersion(latestReleaseVersion).or(() -> Optional.of(new Version(latestReleaseVersion, null))).ifPresent(x -> {
                        info.latestReleaseVersion = x;
                    });
                }
                LOG.debug("update(): latest snapshot (metadata) = " + latestSnapshotVersion);
                LOG.debug("update(): latest release  (metadata) = " + latestReleaseVersion);
                info.lastRepositoryUpdate = lastChangeDate;
                info.lastSuccessDate = ZonedDateTime.now();
                if (StringUtils.isNotBlank((CharSequence)artifact.version) && info.getVersion(artifact.version).isEmpty()) {
                    LOG.error("update(): Found no metadata about version '" + artifact.version + "'of  artifact " + info.artifact);
                    return IVersionProvider.UpdateResult.ARTIFACT_VERSION_NOT_FOUND;
                }
                return IVersionProvider.UpdateResult.UPDATED;
            });
            return object;
        }
        catch (Exception e) {
            info.lastFailureDate = ZonedDateTime.now();
            if (e instanceof FileNotFoundException) {
                LOG.warn("getLatestVersion(): Failed to find artifact on server: " + info);
                IVersionProvider.UpdateResult updateResult = IVersionProvider.UpdateResult.ARTIFACT_UNKNOWN;
                return updateResult;
            }
            LOG.error("getLatestVersion(): Error while retrieving artifact metadata from server: " + info + ": " + e.getMessage(), (Throwable)(LOG.isDebugEnabled() ? e : null));
            throw new IOException(e);
        }
        finally {
            LOG.debug("Finished retrieving metadata for " + info.artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(Runnable r) {
        Object object = this.THREAD_POOL_LOCK;
        synchronized (object) {
            if (this.threadPool == null) {
                LOG.info("setMaxConcurrentThreads(): Using " + this.maxConcurrentThreads + " threads to retrieve artifact metadata.");
                ArrayBlockingQueue<Runnable> workingQueue = new ArrayBlockingQueue<Runnable>(200);
                this.threadPool = new ThreadPoolExecutor(this.maxConcurrentThreads, this.maxConcurrentThreads, 60L, TimeUnit.SECONDS, workingQueue, this.threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
            }
            this.threadPool.submit(r);
        }
    }

    private Map<String, Version> queryReleaseDates(Artifact artifact, Set<String> versionNumbers) {
        HashMap<String, Version> result = new HashMap<String, Version>();
        if (versionNumbers.isEmpty()) {
            return result;
        }
        CountDownLatch latch = new CountDownLatch(versionNumbers.size());
        for (String versionNumber : versionNumbers) {
            Runnable r = () -> {
                block8: {
                    try {
                        Optional<ZonedDateTime> v = this.queryReleaseDate(artifact, versionNumber);
                        if (!v.isPresent()) break block8;
                        Map map = result;
                        synchronized (map) {
                            result.put(versionNumber, new Version(versionNumber, v.get()));
                        }
                    }
                    catch (Exception e) {
                        LOG.error("readVersion(): Failed to retrieve version '" + versionNumber + "' for " + artifact, (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            };
            this.submit(r);
        }
        while (true) {
            try {
                if (latch.await(10L, TimeUnit.SECONDS)) {
                    return result;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.debug("readVersions(): Still waiting for " + latch.getCount() + " outstanding requests of artifact " + artifact);
        }
    }

    private Optional<ZonedDateTime> queryReleaseDate(Artifact artifact, String versionString) throws IOException {
        URL url = this.newRESTUrlBuilder().groupId(artifact.groupId).artifactId(artifact.artifactId).version(versionString).classifier(artifact.classifier).build();
        return this.performGET(url, stream -> {
            PartialResult result = this.parseSonatypeResponse(stream);
            return result.getFirstResult().filter(Version::hasReleaseDate).map(x -> x.releaseDate);
        });
    }

    SonatypeRestAPIUrlBuilder newRESTUrlBuilder() {
        return new SonatypeRestAPIUrlBuilder(this.sonatypeRestApiBaseUrl);
    }

    private List<Version> queryAllVersions(Artifact artifact) throws IOException {
        SonatypeRestAPIUrlBuilder urlBuilder = this.newRESTUrlBuilder().groupId(artifact.groupId).artifactId(artifact.artifactId).classifier(artifact.classifier).returnAllResults();
        URL restApiURL = urlBuilder.build();
        PartialResult first = this.performGET(restApiURL, this::parseSonatypeResponse);
        int remaining = first.totalResultSize() - first.data().size();
        ArrayList<Version> result = new ArrayList<Version>(first.data());
        if (remaining > 0) {
            int resultCount;
            PartialResult tmp;
            LOG.debug("queryAllVersions(): Artifact " + artifact + " has " + first.totalResultSize() + " releases.");
            int offset = first.data().size();
            do {
                restApiURL = urlBuilder.startOffset(offset).build();
                tmp = this.performGET(restApiURL, this::parseSonatypeResponse);
                result.addAll(tmp.data());
                resultCount = tmp.data().size();
                offset += resultCount;
            } while (!tmp.data().isEmpty() && (remaining -= resultCount) > 0);
        }
        if (result.size() != first.totalResultSize()) {
            String msg = "Tried to retrieve " + first.totalResultSize() + " versions for " + artifact + " but only got " + result.size();
            LOG.error("queryAllVersions(): " + msg);
            throw new IOException(msg);
        }
        ZonedDateTime now = ZonedDateTime.now();
        for (Version v : result) {
            v.firstSeenByServer = now;
        }
        return result;
    }

    private PartialResult parseSonatypeResponse(InputStream stream) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        byte[] data = stream.readAllBytes();
        String json = new String(data, StandardCharsets.UTF_8);
        HashMap map = (HashMap)JSON_MAPPER.readValue(json, (TypeReference)typeRef);
        ArrayList<Version> result = new ArrayList<Version>();
        Map response = (Map)map.get("response");
        if (response == null) {
            throw new IOException("getReleaseDateNew(): JSON response contained no 'response' attribute?");
        }
        if (!response.containsKey("numFound")) {
            throw new IOException("JSON response contained no 'numFound' attribute?");
        }
        int numFound = ((Number)response.get("numFound")).intValue();
        if (LOG.isTraceEnabled()) {
            LOG.trace("getReleaseDateNew(): Response found " + numFound + " artifacts");
        }
        List docs = (List)response.get("docs");
        for (Map artifactDetails : docs) {
            if (!artifactDetails.containsKey("timestamp")) continue;
            long ts = ((Number)artifactDetails.get("timestamp")).longValue();
            String version = (String)artifactDetails.get("v");
            ZonedDateTime releaseDate = Instant.ofEpochMilli(ts).atZone(ZoneId.systemDefault());
            result.add(new Version(version, releaseDate));
        }
        if (numFound > 0 && result.isEmpty()) {
            LOG.warn("getReleaseDateNew(): JSON response contained " + docs.size() + " artifacts but none had a 'timestamp' attribute?");
        }
        return new PartialResult(result, numFound);
    }

    public static Document parseXML(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("input stream cannot be NULL");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        StringBuilder xml = MavenCentralVersionProvider.logServerResponseOnError() ? MavenCentralVersionProvider.inputStreamToString(inputStream) : null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new DummyResolver());
            if (MavenCentralVersionProvider.logServerResponseOnError()) {
                inputStream = new ByteArrayInputStream(xml.toString().getBytes(StandardCharsets.UTF_8));
            }
            return builder.parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            LOG.error("parseXML(): Failed to parse document: " + e.getMessage(), (Throwable)(LOG.isDebugEnabled() ? e : null));
            if (MavenCentralVersionProvider.logServerResponseOnError()) {
                LOG.error("parseXML(): Response from server: " + xml);
            }
            throw new IOException("Failed to parse document: " + e.getMessage(), e);
        }
    }

    private static StringBuilder inputStreamToString(InputStream inputStream) throws IOException {
        StringBuilder xml = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            int len;
            char[] buffer = new char[1024];
            while ((len = reader.read(buffer)) > 0) {
                xml.append(buffer, 0, len);
            }
        }
        return xml;
    }

    private static boolean logServerResponseOnError() {
        return LOG.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getClient(URI uri) {
        Map<URI, CloseableHttpClient> map = this.clients;
        synchronized (map) {
            CloseableHttpClient client = this.clients.get(uri);
            if (client == null) {
                DefaultConnectionKeepAliveStrategy defaultKeepAlive = new DefaultConnectionKeepAliveStrategy();
                client = HttpClients.custom().setKeepAliveStrategy((ConnectionKeepAliveStrategy)defaultKeepAlive).setConnectionManager((HttpClientConnectionManager)this.connManager).setConnectionManagerShared(true).build();
                this.clients.put(uri, client);
            }
            return client;
        }
    }

    /*
     * Exception decompiling
     */
    private <T> T performGET(URL url2, MyStreamHandler<T> handler) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readString(XPathExpression expression, Document document) throws IOException {
        try {
            return expression.evaluate(document);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("parseXML(): Failed to parse document: " + e.getMessage(), (Throwable)e);
            } else {
                LOG.error("parseXML(): Failed to parse document: " + e.getMessage());
            }
            throw new IOException("Failed to parse document: " + e.getMessage(), e);
        }
    }

    private List<String> readStrings(XPathExpression expression, Document document) throws IOException {
        try {
            NodeList nodeList = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
            int len = nodeList.getLength();
            ArrayList<String> result = new ArrayList<String>(len);
            for (int i = 0; i < len; ++i) {
                Node n = nodeList.item(i);
                String versionString = n.getTextContent();
                result.add(versionString);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("parseXML(): Failed to parse document: " + e.getMessage(), (Throwable)e);
            throw new IOException("Failed to parse document: " + e.getMessage(), e);
        }
    }

    static String metaDataPath(Artifact artifact) {
        return artifact.groupId.replace('.', '/') + "/" + artifact.artifactId + "/maven-metadata.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVersionProvider.Statistics getStatistics() {
        IVersionProvider.Statistics statistics = this.statistics;
        synchronized (statistics) {
            return this.statistics.createCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStatistics() {
        IVersionProvider.Statistics statistics = this.statistics;
        synchronized (statistics) {
            this.statistics.reset();
        }
    }

    private static /* synthetic */ Integer lambda$performGET$12(Integer k, Integer v) {
        return v == null ? 1 : v + 1;
    }

    @FunctionalInterface
    public static interface MyStreamHandler<T> {
        public T process(InputStream var1) throws IOException;
    }

    private record PartialResult(List<Version> data, int totalResultSize) {
        private PartialResult {
            Validate.notNull(data, (String)"data must not be null", (Object[])new Object[0]);
            Validate.isTrue((totalResultSize >= 0 ? 1 : 0) != 0);
        }

        public Optional<Version> getFirstResult() {
            return this.data.isEmpty() ? Optional.empty() : Optional.of(this.data.get(0));
        }
    }

    private static final class DummyResolver
    implements EntityResolver {
        private DummyResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            ByteArrayInputStream dummy = new ByteArrayInputStream(new byte[0]);
            return new InputSource(dummy);
        }
    }

    private static final class MyExpressions {
        private final XPathExpression latestSnapshot;
        private final XPathExpression latestRelease;
        private final XPathExpression lastUpdateDate;

        public MyExpressions() {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            try {
                this.latestSnapshot = xpath.compile("/metadata/versioning/latest[text()]");
                this.latestRelease = xpath.compile("/metadata/versioning/release[text()]");
                this.lastUpdateDate = xpath.compile("/metadata/versioning/lastUpdated");
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static enum HttpParam {
        QUERY("q", 1),
        OPT_RETURN_ALL_VERSION("core", "gav", 2),
        START_OFFSET("start", 3),
        MAX_RESULT_COUNT("rows", 4),
        RESULT_TYPE("wt", "json", 5);

        public final String literal;
        public final String value;
        public final int order;

        private HttpParam(String literal, int order) {
            this(literal, null, order);
        }

        private HttpParam(String literal, String value, int order) {
            this.literal = literal;
            this.value = value;
            this.order = order;
        }
    }
}

