/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.RequestsPerHour;
import de.codesourcery.versiontracker.common.VersionInfo;
import java.io.Closeable;
import java.time.ZonedDateTime;

public interface IBackgroundUpdater
extends AutoCloseable,
Closeable {
    public Statistics getStatistics();

    public void resetStatistics();

    public void startThread();

    public boolean requiresUpdate(VersionInfo var1, Artifact var2);

    public static final class Statistics {
        public volatile ZonedDateTime lastStatisticsReset = ZonedDateTime.now();
        public final RequestsPerHour scheduledUpdates;

        public Statistics() {
            this.scheduledUpdates = new RequestsPerHour();
        }

        public Statistics(Statistics other) {
            this.scheduledUpdates = other.scheduledUpdates.createCopy();
            this.lastStatisticsReset = other.lastStatisticsReset;
        }

        public void reset() {
            this.scheduledUpdates.reset();
            this.lastStatisticsReset = ZonedDateTime.now();
        }

        public Statistics createCopy() {
            return new Statistics(this);
        }
    }
}

