/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.codesourcery.versiontracker.client.api.IAPIClient;
import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.IVersionStorage;
import de.codesourcery.versiontracker.common.JSONHelper;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.common.VersionInfo;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatFileStorage
implements IVersionStorage {
    private static final Logger LOG = LogManager.getLogger(FlatFileStorage.class);
    private static final DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.of("UTC"));
    private static final int MAGIC_LENGTH_IN_BYTES = 8;
    private static final int RECORD_TAG_LENGTH_IN_BYTES = 1;
    private static final int MINIMUM_BINARY_FILESIZE = 9;
    private static final long MAGIC_V1 = -559038737L;
    private static final long MAGIC_V2 = -559023410L;
    private static final long[] VALID_MAGICS = new long[]{-559038737L, -559023410L};
    private static final ObjectMapper mapper = JSONHelper.newObjectMapper();
    private final SerializationFormat serializationFormatToWrite;
    public SerializationFormat lastFileReadSerializationVersion;
    private final IAPIClient.Protocol protocol;
    private final File file;
    private final IVersionStorage.StorageStatistics storageStatistics = new IVersionStorage.StorageStatistics();

    public String toString() {
        return "FlatFileStorage[ " + this.file.getAbsolutePath() + " ]";
    }

    public FlatFileStorage(File file, IAPIClient.Protocol protocol) {
        this(file, protocol, SerializationFormat.latest());
    }

    public FlatFileStorage(File file, IAPIClient.Protocol protocol, SerializationFormat serializationFormatToWrite) {
        this.file = file;
        this.protocol = protocol;
        this.serializationFormatToWrite = serializationFormatToWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVersionStorage.StorageStatistics getStatistics() {
        IVersionStorage.StorageStatistics storageStatistics = this.storageStatistics;
        synchronized (storageStatistics) {
            return this.storageStatistics.createCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStatistics() {
        IVersionStorage.StorageStatistics storageStatistics = this.storageStatistics;
        synchronized (storageStatistics) {
            this.storageStatistics.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<VersionInfo> getAllVersions() throws IOException {
        boolean assignMissingFirstSeenDate;
        ArrayList<VersionInfo> result;
        if (!this.file.exists()) {
            return new ArrayList<VersionInfo>(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllVersions(): Loading data from {} file: {}", (Object)this.protocol, (Object)this.file.getAbsolutePath());
        }
        if (this.protocol == IAPIClient.Protocol.BINARY) {
            block32: {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
                     BinarySerializer serializer = new BinarySerializer(BinarySerializer.IBuffer.wrap(in));){
                    long magic = serializer.readLong();
                    if (magic == -559038737L) {
                        int count = serializer.readInt();
                        result = new ArrayList<VersionInfo>(count);
                        for (int i = 0; i < count; ++i) {
                            result.add(VersionInfo.deserialize(serializer, SerializationFormat.V1));
                        }
                        break block32;
                    }
                    if (magic == -559023410L) {
                        byte tag;
                        this.lastFileReadSerializationVersion = SerializationFormat.fromVersionNumber(serializer.readShort());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getAllVersions(): File {} uses {}", (Object)this.file.getAbsolutePath(), (Object)this.lastFileReadSerializationVersion);
                        }
                        result = new ArrayList();
                        while ((tag = serializer.readByte()) != TaggedRecordType.END_OF_FILE.tag) {
                            int recordLength = serializer.readInt();
                            if (tag == TaggedRecordType.VERSION_DATA.tag) {
                                byte[] payload = new byte[recordLength];
                                serializer.readBytes(payload);
                                BinarySerializer tmp = new BinarySerializer(BinarySerializer.IBuffer.wrap(payload));
                                while (!tmp.isEOF()) {
                                    result.add(VersionInfo.deserialize(tmp, this.lastFileReadSerializationVersion));
                                }
                                continue;
                            }
                            if (recordLength <= 0) continue;
                            LOG.warn("getAllVersions(): Skipping unknown record with type 0x" + Integer.toHexString(tag & 0xFF));
                            serializer.buffer.skip(recordLength);
                        }
                        break block32;
                    }
                    throw new IOException("File " + this.file + " contains invalid magic value " + Long.toHexString(magic));
                }
            }
            assignMissingFirstSeenDate = this.lastFileReadSerializationVersion.isBefore(SerializationFormat.V3);
        } else if (this.protocol == IAPIClient.Protocol.JSON) {
            result = (ArrayList<VersionInfo>)mapper.readValue(this.file, (TypeReference)new TypeReference<List<VersionInfo>>(){});
            assignMissingFirstSeenDate = true;
        } else {
            throw new RuntimeException("Unhandled protocol " + this.protocol);
        }
        ZonedDateTime mostRecentRequested = null;
        ZonedDateTime mostRecentFailure = null;
        ZonedDateTime mostRecentSuccess = null;
        int totalVersionCount = 0;
        boolean dataMigrated = false;
        ZonedDateTime now = ZonedDateTime.now();
        for (VersionInfo versionInfo : result) {
            if (assignMissingFirstSeenDate) {
                for (Version version : versionInfo.versions) {
                    if (version.firstSeenByServer != null) continue;
                    version.firstSeenByServer = version.hasReleaseDate() ? version.releaseDate : now;
                    dataMigrated = true;
                }
            }
            totalVersionCount += versionInfo.versions.size();
            if (versionInfo.lastRequestDate != null) {
                mostRecentRequested = FlatFileStorage.max(versionInfo.lastRequestDate, mostRecentRequested);
            }
            if (versionInfo.lastFailureDate != null) {
                mostRecentFailure = FlatFileStorage.max(versionInfo.lastFailureDate, mostRecentFailure);
            }
            if (versionInfo.lastSuccessDate == null) continue;
            mostRecentSuccess = FlatFileStorage.max(versionInfo.lastSuccessDate, mostRecentSuccess);
        }
        if (dataMigrated) {
            LOG.debug("getAllVersions(): Migrated " + result.size() + " database entries from " + this.lastFileReadSerializationVersion + " => " + this.serializationFormatToWrite);
            this.writeToDisk(result);
        }
        IVersionStorage.StorageStatistics storageStatistics = this.storageStatistics;
        synchronized (storageStatistics) {
            this.storageStatistics.storageSizeInBytes = this.file.length();
            this.storageStatistics.reads.update(result.size());
            this.storageStatistics.totalArtifactCount = result.size();
            this.storageStatistics.totalVersionCount = totalVersionCount;
            this.storageStatistics.mostRecentSuccess = mostRecentSuccess;
            this.storageStatistics.mostRecentFailure = mostRecentFailure;
            this.storageStatistics.mostRecentRequested = mostRecentRequested;
        }
        return result;
    }

    private static ZonedDateTime max(ZonedDateTime d1, ZonedDateTime d2) {
        if (d1 != null && d2 != null) {
            return d1.compareTo(d2) > 0 ? d1 : d2;
        }
        return d1 == null ? d2 : d1;
    }

    private static String toKey(VersionInfo x) {
        return x.artifact.groupId + ":" + x.artifact.artifactId;
    }

    public static void main(String[] args) throws IOException {
        String in = "/home/tobi/tmp/versiontracker/artifacts.json.binary";
        String out = "/home/tobi/tmp/versiontracker/artifacts.json.binary.txt";
        FlatFileStorage.dumpToFile(new File("/home/tobi/tmp/versiontracker/artifacts.json.binary"), new File("/home/tobi/tmp/versiontracker/artifacts.json.binary.txt"), FlatFileStorage.guessFileType(new File("/home/tobi/tmp/versiontracker/artifacts.json.binary")).orElseThrow());
    }

    public static void dumpToFile(File inputFile, File outputFile, IAPIClient.Protocol protocol) throws IOException {
        String text = FlatFileStorage.dumpToString(inputFile, protocol);
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.write(text);
        }
    }

    public static String dumpToString(File file, IAPIClient.Protocol protocol) throws IOException {
        Function<ZonedDateTime, String> func = time -> time == null ? "n/a" : format.format((TemporalAccessor)time);
        StringBuilder buffer = new StringBuilder();
        FlatFileStorage storage = new FlatFileStorage(file, protocol);
        for (VersionInfo i : storage.getAllVersions()) {
            buffer.append("-----------------------------------").append("\n");
            buffer.append("group id: ").append(i.artifact.groupId).append("\n");
            buffer.append("artifact id: ").append(i.artifact.artifactId).append("\n");
            if (i.latestReleaseVersion != null) {
                buffer.append("latest release: ").append(i.latestReleaseVersion.versionString).append(" (").append(FlatFileStorage.printDate(i.latestReleaseVersion.releaseDate)).append(")").append("\n");
            } else {
                buffer.append("latest release : n/a").append("\n");
            }
            if (i.latestSnapshotVersion != null) {
                buffer.append("latest snapshot : ").append(i.latestSnapshotVersion.versionString).append(" (").append(FlatFileStorage.printDate(i.latestSnapshotVersion.releaseDate)).append(")").append("\n");
            } else {
                buffer.append("latest snapshot : n/a").append("\n");
            }
            if (i.versions == null || i.versions.isEmpty()) {
                buffer.append("versions: n/a").append("\n");
            } else {
                buffer.append("versions:").append("\n");
                ArrayList<Version> list = new ArrayList<Version>(i.versions);
                list.sort(Comparator.comparing(a -> a.versionString));
                for (Version v : list) {
                    buffer.append("            ").append(v.versionString).append(" (").append(func.apply(v.releaseDate)).append(")").append("\n");
                }
            }
            buffer.append("lastRequestDate: ").append(FlatFileStorage.printDate(i.lastRequestDate)).append("\n");
            buffer.append("creationDate: ").append(FlatFileStorage.printDate(i.creationDate)).append("\n");
            buffer.append("lastSuccessDate: ").append(FlatFileStorage.printDate(i.lastSuccessDate)).append("\n");
            buffer.append("lastFailureDate: ").append(FlatFileStorage.printDate(i.lastFailureDate)).append("\n");
            buffer.append("lastRepositoryUpdate: ").append(FlatFileStorage.printDate(i.lastRepositoryUpdate)).append("\n");
        }
        return buffer.toString();
    }

    private static String printDate(ZonedDateTime dt) {
        if (dt == null) {
            return "n/a";
        }
        return format.format(dt);
    }

    @Override
    public synchronized void saveOrUpdate(VersionInfo info) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("saveOrUpdate(): Called for " + info);
        }
        List<VersionInfo> toUpdate = this.getAllVersions();
        toUpdate.removeIf(item -> item.artifact.matchesExcludingVersion(info.artifact));
        toUpdate.add(info);
        this.writeToDisk(toUpdate);
    }

    @Override
    public synchronized void saveOrUpdate(List<VersionInfo> data) throws IOException {
        Set set = data.stream().map(FlatFileStorage::toKey).collect(Collectors.toSet());
        List<VersionInfo> toUpdate = this.getAllVersions();
        toUpdate.removeIf(x -> set.contains(FlatFileStorage.toKey(x)));
        toUpdate.addAll(data);
        this.writeToDisk(toUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(List<VersionInfo> allItems) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("saveOrUpdate(): Persisting " + allItems.size() + " entries...");
        }
        long start = System.nanoTime();
        try {
            File tmpFile;
            block30: {
                tmpFile = new File(this.file.getAbsolutePath() + ".tmp");
                if (tmpFile.exists()) {
                    Files.delete(tmpFile.toPath());
                }
                if (this.protocol == IAPIClient.Protocol.BINARY) {
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile));
                         BinarySerializer serializer = new BinarySerializer(BinarySerializer.IBuffer.wrap(out));){
                        serializer.writeLong(-559023410L);
                        serializer.writeShort(this.serializationFormatToWrite.version);
                        if (!allItems.isEmpty()) {
                            serializer.writeByte(TaggedRecordType.VERSION_DATA.tag);
                            ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
                            try (BinarySerializer serializer2 = new BinarySerializer(BinarySerializer.IBuffer.wrap(tmpOut));){
                                for (VersionInfo info : allItems) {
                                    info.serialize(serializer2, this.serializationFormatToWrite);
                                }
                            }
                            byte[] payload = tmpOut.toByteArray();
                            serializer.writeInt(payload.length);
                            serializer.writeBytes(payload);
                        }
                        serializer.writeByte(TaggedRecordType.END_OF_FILE.tag);
                        break block30;
                    }
                }
                if (this.protocol == IAPIClient.Protocol.JSON) {
                    mapper.writeValue(tmpFile, allItems);
                } else {
                    throw new RuntimeException("Unhandled protocol: " + this.protocol);
                }
            }
            Files.move(tmpFile.toPath(), this.file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            IVersionStorage.StorageStatistics storageStatistics = this.storageStatistics;
            synchronized (storageStatistics) {
                this.storageStatistics.storageSizeInBytes = this.file.length();
                this.storageStatistics.totalArtifactCount = allItems.size();
                this.storageStatistics.totalVersionCount = allItems.stream().mapToInt(x -> x.versions.size()).sum();
                this.storageStatistics.writes.update(allItems.size());
            }
        }
        finally {
            if (LOG.isDebugEnabled()) {
                long end = System.nanoTime();
                long elapsedMillis = (end - start) / 1000000L;
                LOG.debug("saveOrUpdate(): Persisted " + allItems.size() + " entries in " + elapsedMillis + " ms");
            }
        }
    }

    @Override
    public void close() throws Exception {
        LOG.info("close(): File storage for " + this.file + " got closed");
    }

    public static void convert(File input, IAPIClient.Protocol inputProtocol, File output, IAPIClient.Protocol outputProtocol) throws Exception {
        if (input.equals(output)) {
            throw new IllegalArgumentException("Input and output file must differ");
        }
        output.delete();
        try (FlatFileStorage in = new FlatFileStorage(input, inputProtocol);
             FlatFileStorage out = new FlatFileStorage(output, outputProtocol);){
            out.saveOrUpdate(in.getAllVersions());
        }
    }

    public static Optional<IAPIClient.Protocol> guessFileType(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file: " + file.getAbsolutePath());
        }
        try (InputStreamReader in = new InputStreamReader(new FileInputStream(file));){
            while (true) {
                int character;
                if ((character = in.read()) != -1 && Character.isWhitespace(character)) continue;
                if (character == 91) {
                    Optional<IAPIClient.Protocol> optional = Optional.of(IAPIClient.Protocol.JSON);
                    return optional;
                }
                break;
            }
        }
        if (file.length() < 9L) {
            return Optional.empty();
        }
        try (BinarySerializer ser = new BinarySerializer(BinarySerializer.IBuffer.wrap(new FileInputStream(file)));){
            long value = ser.readLong();
            if (Arrays.stream(VALID_MAGICS).anyMatch(validMagic -> value == validMagic)) {
                Optional<IAPIClient.Protocol> optional = Optional.of(IAPIClient.Protocol.BINARY);
                return optional;
            }
        }
        return Optional.empty();
    }

    public static enum TaggedRecordType {
        VERSION_DATA(1),
        END_OF_FILE(255);

        final byte tag;

        private TaggedRecordType(int tag) {
            this.tag = (byte)tag;
        }
    }
}

