/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.common.server.Configuration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationProvider
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(ConfigurationProvider.class);
    private final AtomicReference<Configuration> configuration = new AtomicReference();
    private Thread bgThread;
    private volatile boolean terminate;
    private final Object SLEEP_LOCK = new Object();
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private volatile Duration reloadCheckInterval = Duration.ofSeconds(1L);

    private synchronized void startBgThread() {
        if (!(this.terminate || this.bgThread != null && this.bgThread.isAlive())) {
            this.bgThread = new Thread(){
                {
                    this.setName("config-reload-thread");
                    this.setDaemon(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (!ConfigurationProvider.this.terminate) {
                            Object object = ConfigurationProvider.this.SLEEP_LOCK;
                            synchronized (object) {
                                try {
                                    if (!ConfigurationProvider.this.terminate) {
                                        ConfigurationProvider.this.SLEEP_LOCK.wait(ConfigurationProvider.this.reloadCheckInterval.toMillis());
                                    }
                                    if (ConfigurationProvider.this.terminate) {
                                        return;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            try {
                                LOG.debug("Checking whether configuration has changed...");
                                Optional<Configuration.IResource> resource = Configuration.getResource(false);
                                if (!resource.isPresent()) continue;
                                Optional<ZonedDateTime> lastChangeDate = resource.get().lastChangeDate();
                                Configuration currentConfig = ConfigurationProvider.this.configuration.get();
                                if (!lastChangeDate.isPresent() || currentConfig == null || !currentConfig.timestamp.isBefore(lastChangeDate.get())) continue;
                                LOG.info("Configuration change detected, reloading...");
                                Configuration newConfig = new Configuration();
                                newConfig.load();
                                if (ConfigurationProvider.this.configuration.compareAndSet(currentConfig, newConfig)) {
                                    LOG.info("Configuration reloaded");
                                    continue;
                                }
                                LOG.warn("Configuration change in the meantime?");
                            }
                            catch (IOException iOException) {}
                        }
                        return;
                    }
                    finally {
                        ConfigurationProvider.this.shutdownLatch.countDown();
                    }
                }
            };
            this.bgThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws InterruptedException {
        this.terminate = true;
        Object object = this.SLEEP_LOCK;
        synchronized (object) {
            this.SLEEP_LOCK.notifyAll();
        }
        if (this.bgThread != null && this.bgThread.isAlive()) {
            this.shutdownLatch.await();
        }
    }

    public synchronized Configuration getConfiguration() {
        this.startBgThread();
        if (this.configuration.get() == null) {
            Configuration c = new Configuration();
            try {
                c.load();
                this.configuration.set(c);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.configuration.get();
    }
}

