/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.common.Blacklist;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Configuration {
    private static final Logger LOG = LogManager.getLogger(Configuration.class);
    private static final String DEFAULT_CONFIG_FILE_LOCATION = "classpath:/versionTracker.json";
    public static final String CONFIG_FILE_LOCATION_SYS_PROPERTY = "versionTracker.configFile";
    private volatile Blacklist blacklist = new Blacklist();
    private volatile Duration minUpdateDelayAfterFailure = Duration.ofDays(1L);
    private volatile Duration minUpdateDelayAfterSuccess = Duration.ofDays(1L);
    private volatile Duration bgUpdateCheckInterval = Duration.ofMinutes(1L);
    private volatile File dataStore;
    public final ZonedDateTime timestamp = ZonedDateTime.now();

    public Blacklist getBlacklist() {
        return this.blacklist;
    }

    public void load() throws IOException {
        Optional<IResource> resource = Configuration.getResource(true);
        if (resource.isEmpty()) {
            LOG.info("Using built-in configuration.");
            return;
        }
        LOG.info("Loading configuration from " + resource);
        this.load(resource.get());
    }

    public static Optional<IResource> getResource(boolean verbose) throws IOException {
        IResource resource;
        boolean fromSystemProperty;
        Object location = System.getProperty(CONFIG_FILE_LOCATION_SYS_PROPERTY);
        if (location != null) {
            if (verbose) {
                LOG.info("Configuration (system property 'versionTracker.configFile') = " + (String)location);
            }
            fromSystemProperty = true;
            if (!((String)location).toLowerCase().startsWith("file:")) {
                location = "file:" + (String)location;
            }
        } else {
            location = DEFAULT_CONFIG_FILE_LOCATION;
            if (verbose) {
                LOG.info("Configuration (default location) " + (String)location);
            }
            fromSystemProperty = false;
        }
        if (((String)location).toLowerCase().startsWith("file:")) {
            resource = new FileResource(new File(((String)location).substring("file:".length())));
            if (!resource.exists() && !fromSystemProperty) {
                if (verbose) {
                    LOG.info("No configuration found in default location (classpath:/versionTracker.json)");
                }
                return Optional.empty();
            }
        } else if (((String)location).toLowerCase().startsWith("classpath:")) {
            resource = new ClasspathResource(((String)location).substring("classpath:".length()));
            if (!resource.exists()) {
                if (fromSystemProperty) {
                    LOG.error("Failed to load configuration from '" + (String)location + "'");
                    throw new IOException("Failed to load configuration from '" + (String)location + "'");
                }
                return Optional.empty();
            }
        } else {
            String msg = "Invalid config file location '" + (String)location + "', needs to be prefixed with 'classpath:' or 'file:'";
            LOG.error(msg);
            throw new IOException(msg);
        }
        return Optional.of(resource);
    }

    public void load(IResource resource) throws IOException {
        try (InputStream in = resource.open();){
            Properties props = new Properties();
            props.load(in);
            String ds = props.getProperty("dataStorage");
            this.dataStore = ds != null ? new File(ds) : null;
            this.minUpdateDelayAfterFailure = this.getDuration(props, "updateDelayAfterFailure", this.minUpdateDelayAfterFailure);
            this.minUpdateDelayAfterSuccess = this.getDuration(props, "updateDelayAfterSuccess", this.minUpdateDelayAfterSuccess);
            this.bgUpdateCheckInterval = this.getDuration(props, "bgUpdateCheckInterval", this.bgUpdateCheckInterval);
            LOG.info("data storage= " + this.dataStore);
            LOG.info("min. update delay after failure = " + this.minUpdateDelayAfterFailure);
            LOG.info("min. update delay after success = " + this.minUpdateDelayAfterSuccess);
            LOG.info("bg update check interval = " + this.bgUpdateCheckInterval);
            Blacklist newBlacklist = new Blacklist();
            String blacklistedGroupIds = props.getProperty("blacklistedGroupIds");
            if (StringUtils.isNotBlank((CharSequence)blacklistedGroupIds)) {
                String[] ids;
                LOG.info("Blacklisted group IDs: " + blacklistedGroupIds);
                for (String id : ids = blacklistedGroupIds.split("[, ]")) {
                    newBlacklist.addIgnoredVersion(id, ".*", Blacklist.VersionMatcher.REGEX);
                }
                this.blacklist = newBlacklist;
            }
        }
    }

    private String getProperty(Properties props, String property) {
        String result = System.getProperty("versionTracker." + property);
        if (result != null) {
            return result;
        }
        return props.getProperty(property);
    }

    private Duration getDuration(Properties props, String key, Duration defaultValue) {
        String value = this.getProperty(props, key);
        if (value == null) {
            return defaultValue;
        }
        return Configuration.parseDurationString(value);
    }

    public void setBlacklist(Blacklist blacklist) {
        Validate.notNull((Object)blacklist, (String)"blacklist must not be null", (Object[])new Object[0]);
        this.blacklist = blacklist;
    }

    public Duration getMinUpdateDelayAfterFailure() {
        return this.minUpdateDelayAfterFailure;
    }

    public void setMinUpdateDelayAfterFailure(Duration minUpdateDelayAfterFailure) {
        Validate.notNull((Object)minUpdateDelayAfterFailure, (String)"minUpdateDelayAfterFailure must not be null", (Object[])new Object[0]);
        Validate.isTrue((minUpdateDelayAfterFailure.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0);
        this.minUpdateDelayAfterFailure = minUpdateDelayAfterFailure;
    }

    public Duration getMinUpdateDelayAfterSuccess() {
        return this.minUpdateDelayAfterSuccess;
    }

    public void setMinUpdateDelayAfterSuccess(Duration minUpdateDelayAfterSuccess) {
        Validate.notNull((Object)minUpdateDelayAfterSuccess, (String)"minUpdateDelayAfterSuccess must not be null", (Object[])new Object[0]);
        Validate.isTrue((minUpdateDelayAfterSuccess.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0);
        this.minUpdateDelayAfterSuccess = minUpdateDelayAfterSuccess;
    }

    public Duration getBgUpdateCheckInterval() {
        return this.bgUpdateCheckInterval;
    }

    public static Duration parseDurationString(String s) {
        Validate.notBlank((CharSequence)s, (String)"s must not be null or blank", (Object[])new Object[0]);
        Pattern p = Pattern.compile("^([0-9]+)([smhd])$", 2);
        Matcher m = p.matcher(s.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid syntax");
        }
        int seconds = Integer.parseInt(m.group(1));
        switch (m.group(2)) {
            case "d": {
                seconds *= 24;
            }
            case "h": {
                seconds *= 60;
            }
            case "m": {
                seconds *= 60;
            }
            case "s": {
                break;
            }
            default: {
                throw new RuntimeException("Unhandled switch/case: " + m.group(2));
            }
        }
        return Duration.ofSeconds(seconds);
    }

    public void setDataStorageFile(File dataStore) {
        this.dataStore = dataStore;
    }

    public Optional<File> getDataStorageFile() {
        return Optional.ofNullable(this.dataStore);
    }

    public static interface IResource {
        public boolean exists();

        public InputStream open() throws IOException;

        public Optional<ZonedDateTime> lastChangeDate();
    }

    private static final class FileResource
    implements IResource {
        public final File file;

        private FileResource(File file) {
            Validate.notNull((Object)file, (String)"file must not be null", (Object[])new Object[0]);
            this.file = file;
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<ZonedDateTime> lastChangeDate() {
            try {
                FileTime time = Files.getLastModifiedTime(this.file.toPath(), new LinkOption[0]);
                return Optional.of(time.toInstant().atZone(ZoneId.systemDefault()));
            }
            catch (IOException e) {
                LOG.warn("Failed to get file modification time from '" + this.file + "': " + e.getMessage());
                return Optional.empty();
            }
        }

        public String toString() {
            return "file:" + this.file.getAbsolutePath();
        }
    }

    private static final class ClasspathResource
    implements IResource {
        public final String classpath;

        private ClasspathResource(String classpath) {
            Validate.notBlank((CharSequence)classpath, (String)"classpath must not be null or blank", (Object[])new Object[0]);
            this.classpath = classpath;
        }

        @Override
        public boolean exists() {
            boolean bl;
            block8: {
                InputStream in = Configuration.class.getResourceAsStream(this.classpath);
                try {
                    boolean bl2 = bl = in != null;
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                in.close();
            }
            return bl;
        }

        @Override
        public InputStream open() throws IOException {
            InputStream in = Configuration.class.getResourceAsStream(this.classpath);
            if (in == null) {
                throw new FileNotFoundException("Failed to open classpath resource " + this);
            }
            return in;
        }

        @Override
        public Optional<ZonedDateTime> lastChangeDate() {
            throw new UnsupportedOperationException("Method lastChangeDate not implemented");
        }

        public String toString() {
            return "classpath:" + this.classpath;
        }
    }
}

