/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.ArtifactMap;
import de.codesourcery.versiontracker.common.IVersionStorage;
import de.codesourcery.versiontracker.common.VersionInfo;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingStorageDecorator
implements IVersionStorage {
    private static final Logger LOG = LogManager.getLogger(CachingStorageDecorator.class);
    private final IVersionStorage delegate;
    private boolean initialized;
    private final ArtifactMap<VersionInfo> dirtyCache = new ArtifactMap();
    private final ArtifactMap<VersionInfo> cleanCache = new ArtifactMap();
    private long lazyFlushes = 0L;
    private volatile Duration cacheFlushInterval = Duration.ofSeconds(10L);
    private final Object THREAD_LOCK = new Object();
    private CacheFlushThread thread;
    private volatile boolean shutdown;

    public CachingStorageDecorator(IVersionStorage delegate) {
        Validate.notNull((Object)delegate, (String)"delegate must not be NULL", (Object[])new Object[0]);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCache() throws IOException {
        ArtifactMap<VersionInfo> artifactMap = this.cleanCache;
        synchronized (artifactMap) {
            if (!this.dirtyCache.isEmpty()) {
                long start = System.currentTimeMillis();
                CollectingVisitor v = new CollectingVisitor(false);
                this.dirtyCache.visitValues(v);
                this.delegate.saveOrUpdate(v.list);
                this.cleanCache.putAll(this.dirtyCache);
                this.dirtyCache.clear();
                this.lazyFlushes += (long)v.list.size();
                if (LOG.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    LOG.debug("flushCache(): Flushed " + v.list.size() + " items in " + elapsed + " ms (total flushed items is now: " + this.lazyFlushes + ")");
                }
            }
        }
    }

    @Override
    public IVersionStorage.StorageStatistics getStatistics() {
        try {
            this.maybeInit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.delegate.getStatistics();
    }

    @Override
    public void resetStatistics() {
        this.delegate.resetStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread() {
        Object object = this.THREAD_LOCK;
        synchronized (object) {
            if (!this.shutdown && this.thread == null) {
                this.thread = new CacheFlushThread();
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInit() throws IOException {
        ArtifactMap<VersionInfo> artifactMap = this.cleanCache;
        synchronized (artifactMap) {
            if (!this.initialized) {
                this.cleanCache.clear();
                this.delegate.getAllVersions().forEach(v -> this.cleanCache.put(v.artifact.groupId, v.artifact.artifactId, (VersionInfo)v));
                LOG.info("maybeInit(): Loaded " + this.cleanCache.size() + " entries from underlying storage");
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VersionInfo> getAllVersions() throws IOException {
        ArtifactMap<VersionInfo> artifactMap = this.cleanCache;
        synchronized (artifactMap) {
            this.maybeInit();
            ArtifactMap<VersionInfo> uniqueSet = new ArtifactMap<VersionInfo>(this.cleanCache);
            uniqueSet.putAll(this.dirtyCache);
            CollectingVisitor collector = new CollectingVisitor(true);
            uniqueSet.visitValues(collector);
            return collector.list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<VersionInfo> getVersionInfo(Artifact artifact) throws IOException {
        ArtifactMap<VersionInfo> artifactMap = this.cleanCache;
        synchronized (artifactMap) {
            this.maybeInit();
            VersionInfo result = this.dirtyCache.get(artifact.groupId, artifact.artifactId);
            if (result == null) {
                result = this.cleanCache.get(artifact.groupId, artifact.artifactId);
            }
            return result == null ? Optional.empty() : Optional.of(result.copy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOrUpdate(VersionInfo info) {
        this.startThread();
        ArtifactMap<VersionInfo> artifactMap = this.cleanCache;
        synchronized (artifactMap) {
            this.dirtyCache.put(info.artifact.groupId, info.artifact.artifactId, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOrUpdate(List<VersionInfo> data) {
        this.startThread();
        ArtifactMap<VersionInfo> artifactMap = this.cleanCache;
        synchronized (artifactMap) {
            for (VersionInfo info : data) {
                this.dirtyCache.put(info.artifact.groupId, info.artifact.artifactId, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        LOG.info("close(): Initiating cache flush upon shutdown...");
        this.flushCache();
        LOG.info("close(): Cache flushed.");
        this.shutdown = true;
        Object object = this.THREAD_LOCK;
        synchronized (object) {
            if (this.thread != null) {
                try {
                    this.thread.shutdown();
                }
                finally {
                    this.thread = null;
                }
            }
        }
    }

    public void setCacheFlushInterval(Duration cacheFlushInterval) {
        this.cacheFlushInterval = cacheFlushInterval;
    }

    public String toString() {
        return "(cached) " + this.delegate.toString();
    }

    private static final class CollectingVisitor
    implements Consumer<VersionInfo> {
        public final List<VersionInfo> list = new ArrayList<VersionInfo>();
        private final boolean doCopy;

        public CollectingVisitor(boolean copy) {
            this.doCopy = copy;
        }

        @Override
        public void accept(VersionInfo t) {
            if (this.doCopy) {
                this.list.add(t.copy());
            } else {
                this.list.add(t);
            }
        }
    }

    protected final class CacheFlushThread
    extends Thread {
        private final Object SLEEP_LOCK = new Object();
        private final CountDownLatch stopLatch = new CountDownLatch(1);

        public CacheFlushThread() {
            this.setName("cache-flush-thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("run(): Cache flushing thread started");
            boolean regularShutdown = false;
            try {
                while (!CachingStorageDecorator.this.shutdown) {
                    CachingStorageDecorator.this.flushCache();
                    try {
                        Object object = this.SLEEP_LOCK;
                        synchronized (object) {
                            this.SLEEP_LOCK.wait(CachingStorageDecorator.this.cacheFlushInterval.toMillis());
                        }
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                regularShutdown = true;
            }
            catch (Exception e1) {
                LOG.error("run(): Caught exception " + e1.getMessage(), (Throwable)e1);
            }
            finally {
                this.stopLatch.countDown();
                LOG.info("run(): Cache flushing thread finished (regular shutdown=" + regularShutdown + ")");
                if (!regularShutdown) {
                    Thread t = new Thread(() -> {
                        LOG.error("run(): Thread finished unexpectedly, restarting in 60 seconds");
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        CachingStorageDecorator.this.startThread();
                    });
                    t.setDaemon(true);
                    t.setName("cache-flush-restarter");
                    t.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws InterruptedException {
            LOG.info("shutdown(): Terminating cache flush thread");
            if (this.isAlive()) {
                CachingStorageDecorator.this.shutdown = true;
                Object object = this.SLEEP_LOCK;
                synchronized (object) {
                    this.SLEEP_LOCK.notifyAll();
                }
                this.stopLatch.await();
            }
        }
    }
}

