/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.IVersionProvider;
import de.codesourcery.versiontracker.common.IVersionStorage;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.common.VersionInfo;
import de.codesourcery.versiontracker.common.server.Configuration;
import de.codesourcery.versiontracker.common.server.ConfigurationProvider;
import de.codesourcery.versiontracker.common.server.IBackgroundUpdater;
import de.codesourcery.versiontracker.common.server.SharedLockCache;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackgroundUpdater
implements IBackgroundUpdater {
    private static final Logger LOG = LogManager.getLogger(BackgroundUpdater.class);
    private final SharedLockCache artifactLocks;
    private final Object THREAD_LOCK = new Object();
    private BGThread thread;
    private volatile boolean shutdown;
    private final IBackgroundUpdater.Statistics statistics = new IBackgroundUpdater.Statistics();
    public ConfigurationProvider configurationProvider;
    private final IVersionStorage storage;
    private final IVersionProvider provider;
    private final ThreadPoolExecutor threadPool;

    public BackgroundUpdater(IVersionStorage storage, IVersionProvider provider, SharedLockCache artifactLocks) {
        Validate.notNull((Object)storage, (String)"storage must not be NULL", (Object[])new Object[0]);
        Validate.notNull((Object)provider, (String)"provider must not be NULL", (Object[])new Object[0]);
        Validate.notNull((Object)artifactLocks, (String)"artifactLocks must not be NULL", (Object[])new Object[0]);
        this.storage = storage;
        this.provider = provider;
        this.artifactLocks = artifactLocks;
        int threadCount = Runtime.getRuntime().availableProcessors();
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger THREAD_ID = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("bg-updater-thread-" + this.THREAD_ID.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        };
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(100);
        this.threadPool = new ThreadPoolExecutor(threadCount, threadCount, 60L, TimeUnit.SECONDS, workQueue, threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void doUpdate() throws Exception {
        Configuration config = this.configurationProvider.getConfiguration();
        List<VersionInfo> infos = this.storage.getAllStaleVersions(config.getMinUpdateDelayAfterSuccess(), config.getMinUpdateDelayAfterFailure(), ZonedDateTime.now());
        LOG.info("doUpdate(): Updating " + infos.size() + " stale artifacts");
        for (VersionInfo info : infos) {
            this.doUpdate(info);
        }
    }

    private boolean requiresUpdate(VersionInfo info) {
        Validate.notNull((Object)info, (String)"info must not be null", (Object[])new Object[0]);
        Configuration configuration = this.configurationProvider.getConfiguration();
        boolean result = IVersionStorage.isStaleVersion(info, configuration.getMinUpdateDelayAfterSuccess(), configuration.getMinUpdateDelayAfterFailure(), ZonedDateTime.now());
        if (LOG.isDebugEnabled()) {
            LOG.debug("requiresUpdate(): Stale (" + info.artifact + ") ? " + (result ? "YES" : "NO"));
        }
        return result;
    }

    @Override
    public boolean requiresUpdate(VersionInfo info, Artifact artifact) {
        Optional<Version> version;
        if (this.requiresUpdate(info)) {
            return true;
        }
        boolean updateNeeded = false;
        if (info.versions.stream().anyMatch(x -> !x.hasReleaseDate())) {
            LOG.debug("requiresUpdate(): Updating {} because at least one version has no release date yet", (Object)artifact);
            updateNeeded = true;
        }
        if (info.latestReleaseVersion != null && !info.latestReleaseVersion.hasReleaseDate()) {
            LOG.debug("requiresUpdate(): Updating {} because the latest release version has no release date yet", (Object)artifact);
            updateNeeded = true;
        }
        if (info.latestSnapshotVersion != null && !info.latestSnapshotVersion.hasReleaseDate()) {
            LOG.debug("requiresUpdate(): Updating {} because the latest snapshot version has no release date yet", (Object)artifact);
            updateNeeded = true;
        }
        if ((version = info.getVersion(artifact.version)).isEmpty() || !version.get().hasReleaseDate()) {
            LOG.debug("requiresUpdate(): Updating {} because the version {} has no release date yet", (Object)artifact, (Object)artifact.version);
            updateNeeded = true;
        }
        if (updateNeeded) {
            boolean lastPollFailed;
            Duration timeSinceLastUpdate = Duration.between(info.lastPolledDate(), ZonedDateTime.now());
            Configuration configuration = this.configurationProvider.getConfiguration();
            Duration duration = configuration.getMinUpdateDelayAfterSuccess();
            boolean bl = lastPollFailed = info.lastFailureDate != null && info.lastPolledDate() == info.lastFailureDate;
            if (lastPollFailed) {
                duration = configuration.getMinUpdateDelayAfterFailure();
            }
            if (timeSinceLastUpdate.compareTo(duration) < 0) {
                LOG.debug("Not performing metadata update as last poll " + (lastPollFailed ? "failed" : "succeeded") + " at " + info.lastPolledDate() + " which happened less than " + duration + " ago");
                return false;
            }
        }
        return updateNeeded;
    }

    public void doUpdate(VersionInfo info) {
        this.submit(() -> this.artifactLocks.doWhileLocked(info.artifact, () -> {
            Optional<VersionInfo> existing = this.storage.getVersionInfo(info.artifact);
            if (existing.map(x -> this.requiresUpdate((VersionInfo)x, x.artifact)).orElse(false).booleanValue()) {
                LOG.debug("doUpdate(): Refreshing " + info.artifact);
                IBackgroundUpdater.Statistics statistics = this.statistics;
                synchronized (statistics) {
                    this.statistics.scheduledUpdates.update();
                }
                try {
                    IVersionProvider.UpdateResult result = this.provider.update(info, info.versions.stream().anyMatch(x -> !x.hasReleaseDate()));
                    LOG.trace("doUpdate(): Updating {} yielded {}", (Object)info.artifact, (Object)result);
                }
                finally {
                    this.storage.saveOrUpdate(info);
                }
            }
            LOG.debug("doUpdate(): Doing nothing, concurrent update to " + info.artifact + " already updated it");
        }));
    }

    private void submit(SharedLockCache.ThrowingRunnable job) {
        this.threadPool.submit(() -> {
            try {
                job.run();
            }
            catch (Exception e) {
                LOG.error("submit(): Caught " + e.getMessage(), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startThread() {
        Object object = this.THREAD_LOCK;
        synchronized (object) {
            if (!this.shutdown) {
                this.thread = new BGThread();
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.shutdown = true;
        Object object = this.THREAD_LOCK;
        synchronized (object) {
            if (this.thread != null) {
                try {
                    this.thread.shutdown();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
                finally {
                    this.thread = null;
                }
            }
        }
        this.threadPool.shutdownNow();
    }

    public void setConfigurationProvider(ConfigurationProvider provider) {
        Validate.notNull((Object)provider, (String)"ConfigurationProvider must not be null", (Object[])new Object[0]);
        this.configurationProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBackgroundUpdater.Statistics getStatistics() {
        IBackgroundUpdater.Statistics statistics = this.statistics;
        synchronized (statistics) {
            return this.statistics.createCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStatistics() {
        IBackgroundUpdater.Statistics statistics = this.statistics;
        synchronized (statistics) {
            this.statistics.reset();
        }
    }

    protected final class BGThread
    extends Thread {
        private final Object SLEEP_LOCK = new Object();
        private final CountDownLatch stopLatch = new CountDownLatch(1);

        public BGThread() {
            this.setDaemon(true);
            this.setName("background-update-thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("run(): Background thread started.");
            boolean regularShutdown = false;
            try {
                while (!BackgroundUpdater.this.shutdown) {
                    BackgroundUpdater.this.doUpdate();
                    Object object = this.SLEEP_LOCK;
                    synchronized (object) {
                        this.SLEEP_LOCK.wait(BackgroundUpdater.this.configurationProvider.getConfiguration().getBgUpdateCheckInterval().toMillis());
                    }
                }
                regularShutdown = true;
            }
            catch (Exception e) {
                LOG.error("run(): Caught unexpected exception " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.stopLatch.countDown();
                LOG.info("run(): Background thread about to stop (regular shutdown=" + regularShutdown + ")");
                if (!regularShutdown) {
                    Thread t = new Thread(() -> {
                        LOG.warn("run(): Thread died unexpectedly, restarting in 60 seconds");
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Exception e) {
                            Thread.currentThread().interrupt();
                        }
                        LOG.warn("run(): Restarting thread that died unexpectedly...");
                        BackgroundUpdater.this.startThread();
                    });
                    t.setDaemon(true);
                    t.setName("bg-restarter-thread");
                    t.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws InterruptedException {
            if (this.isAlive()) {
                BackgroundUpdater.this.shutdown = true;
                Object object = this.SLEEP_LOCK;
                synchronized (object) {
                    this.SLEEP_LOCK.notifyAll();
                }
                this.stopLatch.await();
            }
        }
    }
}

