/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common.server;

import de.codesourcery.versiontracker.client.api.IAPIClient;
import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.ArtifactResponse;
import de.codesourcery.versiontracker.common.Blacklist;
import de.codesourcery.versiontracker.common.IVersionProvider;
import de.codesourcery.versiontracker.common.IVersionStorage;
import de.codesourcery.versiontracker.common.QueryRequest;
import de.codesourcery.versiontracker.common.QueryResponse;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.common.VersionInfo;
import de.codesourcery.versiontracker.common.server.BackgroundUpdater;
import de.codesourcery.versiontracker.common.server.CachingStorageDecorator;
import de.codesourcery.versiontracker.common.server.Configuration;
import de.codesourcery.versiontracker.common.server.ConfigurationProvider;
import de.codesourcery.versiontracker.common.server.FlatFileStorage;
import de.codesourcery.versiontracker.common.server.IBackgroundUpdater;
import de.codesourcery.versiontracker.common.server.IVersionTracker;
import de.codesourcery.versiontracker.common.server.MavenCentralVersionProvider;
import de.codesourcery.versiontracker.common.server.SharedLockCache;
import de.codesourcery.versiontracker.common.server.VersionTracker;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class APIImpl
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(APIImpl.class);
    public static final String SYSTEM_PROPERTY_ARTIFACT_FILE = "versiontracker.artifact.file";
    private IVersionTracker versionTracker;
    private IVersionStorage versionStorage;
    private IVersionProvider versionProvider;
    private IBackgroundUpdater updater;
    private boolean registerShutdownHook = true;
    private String repo1BaseUrl = "https://repo1.maven.org/maven2/";
    private String restApiBaseUrl = "https://search.maven.org/solrsearch/select";
    private final ConfigurationProvider configurationProvider = new ConfigurationProvider();
    private final Mode mode;
    private boolean initialized;

    public APIImpl(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be NULL");
        }
        this.mode = mode;
    }

    private void setLogLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        org.apache.logging.log4j.core.config.Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("de.codesourcery");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    protected IVersionStorage createVersionStorage() {
        IAPIClient.Protocol fileType;
        File versionFile = this.getArtifactFileLocation();
        try {
            if (versionFile.exists() && versionFile.length() > 0L) {
                fileType = FlatFileStorage.guessFileType(versionFile).orElse(null);
                if (fileType == null) {
                    LOG.error("createVersionStorage(): Unable to determine file type of '" + versionFile + "'");
                    throw new RuntimeException("Unable to determine file type of data storage file '" + versionFile + "'");
                }
            } else {
                fileType = versionFile.getName().endsWith(".json") ? IAPIClient.Protocol.JSON : IAPIClient.Protocol.BINARY;
            }
        }
        catch (IOException e) {
            LOG.error("createVersionStorage(): Failed to read '" + versionFile + "'", (Throwable)e);
            throw new UncheckedIOException(e);
        }
        if (fileType == IAPIClient.Protocol.JSON && versionFile.exists() && versionFile.length() > 0L) {
            File binaryFile = new File(versionFile.getAbsolutePath() + ".binary");
            try {
                if (!binaryFile.exists()) {
                    LOG.warn("createVersionStorage(): Using JSON files for storage is deprecated, trying to convert " + versionFile.getAbsolutePath() + " -> " + binaryFile.getAbsolutePath());
                    FlatFileStorage.convert(versionFile, IAPIClient.Protocol.JSON, binaryFile, IAPIClient.Protocol.BINARY);
                    LOG.info("createVersionStorage(): Converted " + versionFile.getAbsolutePath() + " -> " + binaryFile.getAbsolutePath());
                } else {
                    LOG.warn("createVersionStorage(): Configuration tells to use deprecated JSON file " + versionFile + " but binary file " + binaryFile + " exists, will use the latter. Please update your configuration to use the binary file instead.");
                }
                versionFile = binaryFile;
                fileType = IAPIClient.Protocol.BINARY;
            }
            catch (Exception e) {
                LOG.error("createVersionStorage(): Using JSON file , failed to convert " + versionFile.getAbsolutePath() + " -> " + binaryFile.getAbsolutePath(), (Throwable)e);
            }
        }
        LOG.info("init(): Using " + fileType + " file " + versionFile.getAbsolutePath());
        FlatFileStorage fileStorage = new FlatFileStorage(versionFile, fileType);
        return new CachingStorageDecorator(fileStorage);
    }

    protected IVersionProvider createVersionProvider() {
        Blacklist bl = new Blacklist();
        String v = System.getProperty("versionTracker.blacklistedGroupIds");
        if (v != null) {
            String[] ids;
            for (String id : ids = v.split(",")) {
                String groupId = id.trim();
                bl.addIgnoredVersion(groupId, ".*", Blacklist.VersionMatcher.REGEX);
            }
        }
        MavenCentralVersionProvider result = new MavenCentralVersionProvider(this.repo1BaseUrl, this.restApiBaseUrl);
        result.setConfigurationProvider(this.configurationProvider);
        return result;
    }

    private static Optional<Duration> getDurationFromSystemProperties(String key) {
        String v = System.getProperty(key);
        if (v != null) {
            try {
                return Optional.of(Configuration.parseDurationString(v));
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid duration value '" + v + "' for system property '" + key + "' : " + ex.getMessage());
            }
        }
        return Optional.empty();
    }

    protected IBackgroundUpdater createBackgroundUpdater(SharedLockCache lockCache) {
        BackgroundUpdater result = new BackgroundUpdater(this.versionStorage, this.versionProvider, lockCache);
        result.setConfigurationProvider(this.configurationProvider);
        return result;
    }

    protected IVersionTracker createVersionTracker(SharedLockCache lockCache) {
        return new VersionTracker(this.versionStorage, this.versionProvider, lockCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(boolean debugMode, boolean verboseMode) {
        if (this.initialized) {
            return;
        }
        this.configurationProvider.getConfiguration();
        this.versionStorage = this.createVersionStorage();
        this.versionProvider = this.createVersionProvider();
        SharedLockCache lockCache = new SharedLockCache();
        if (debugMode || verboseMode) {
            if (debugMode) {
                this.setLogLevel(Level.DEBUG);
            } else {
                this.setLogLevel(Level.INFO);
            }
        }
        LOG.info("init(): ====================");
        LOG.info("init(): Running in " + this.mode + " mode.");
        if (this.registerShutdownHook) {
            LOG.info("init(): Registering shutdown hook");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    LOG.info("init(): Shutdown hook triggered");
                    this.close();
                }
                catch (Exception e) {
                    LOG.error("Exception during shutdown: " + e.getMessage(), (Throwable)e);
                }
            }));
        }
        this.updater = this.createBackgroundUpdater(lockCache);
        if (this.mode == Mode.SERVER) {
            LOG.info("init(): Starting background update thread.");
            this.updater.startThread();
        }
        boolean success = false;
        try {
            int threadCount = Runtime.getRuntime().availableProcessors() * 2;
            this.versionTracker = this.createVersionTracker(lockCache);
            this.versionTracker.setMaxConcurrentThreads(threadCount);
            LOG.info("init(): Initialization done.");
            LOG.info("init(): ");
            LOG.info("init(): Version file storage: " + this.versionStorage);
            LOG.info("init(): Maven repository enpoint: " + this.repo1BaseUrl);
            LOG.info("init(): Thread count: " + this.versionTracker.getMaxConcurrentThreads());
            LOG.info("init(): ====================");
            success = true;
        }
        finally {
            if (!success) {
                LOG.error("init(): Initialization failed");
                try {
                    this.updater.close();
                }
                catch (Exception e) {
                    LOG.error("init(): Caught " + e.getMessage(), (Throwable)e);
                }
            }
        }
        this.initialized = true;
    }

    private File getArtifactFileLocation() {
        String location = System.getProperty(SYSTEM_PROPERTY_ARTIFACT_FILE);
        if (StringUtils.isNotBlank((CharSequence)location)) {
            LOG.info("getArtifactFileLocation(): Using artifacts file location from 'versiontracker.artifact.file' JVM property");
            return new File(location);
        }
        Optional<File> dataStore = this.configurationProvider.getConfiguration().getDataStorageFile();
        if (dataStore.isPresent()) {
            LOG.info("getArtifactFileLocation(): Using artifacts file location from configuration file: " + dataStore.get());
            return dataStore.get();
        }
        location = System.getProperty("user.home");
        if (StringUtils.isNotBlank((CharSequence)location)) {
            LOG.info("getArtifactFileLocation(): Storing artifacts file relative to 'user.home' JVM property");
            String fileName = "artifacts.json.binary";
            File fallback = new File(location, "artifacts.json.binary");
            File m2Dir = new File(location, ".m2");
            if (m2Dir.exists()) {
                if (!m2Dir.isDirectory()) {
                    return fallback;
                }
                return new File(m2Dir, "artifacts.json.binary");
            }
            if (m2Dir.mkdirs()) {
                LOG.info("getArtifactFileLocation(): Created directory " + m2Dir.getAbsolutePath());
                return new File(m2Dir, "artifacts.json.binary");
            }
            return fallback;
        }
        String msg = "Neither 'user.home' nor 'versiontracker.artifact.file' JVM properties are set, don't know where to store artifact metadata";
        LOG.error("getArtifactFileLocation(): Neither 'user.home' nor 'versiontracker.artifact.file' JVM properties are set, don't know where to store artifact metadata");
        throw new RuntimeException("Neither 'user.home' nor 'versiontracker.artifact.file' JVM properties are set, don't know where to store artifact metadata");
    }

    public QueryResponse processQuery(QueryRequest request) throws InterruptedException {
        QueryResponse result = new QueryResponse();
        Map<Artifact, VersionInfo> results = this.versionTracker.getVersionInfo(request.artifacts, this.updater::requiresUpdate);
        for (Artifact artifact : request.artifacts) {
            VersionInfo info = results.get(artifact);
            if (info == null) {
                throw new RuntimeException("Got no result for " + artifact + "?");
            }
            ArtifactResponse x = new ArtifactResponse();
            result.artifacts.add(x);
            x.artifact = artifact;
            x.updateAvailable = ArtifactResponse.UpdateAvailable.NOT_FOUND;
            if (!info.hasVersions()) continue;
            if (artifact.hasReleaseVersion()) {
                versions = info.getVersionsSortedDescending(Artifact::isReleaseVersion, request.blacklist);
                if (!versions.isEmpty()) {
                    if (versions.size() > 1) {
                        x.secondLatestVersion = versions.get(1);
                    }
                    x.latestVersion = versions.get(0);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("processQuery(): latest release version from metadata: " + info.latestReleaseVersion);
                        LOG.debug("processQuery(): Calculated latest release version: " + x.latestVersion);
                    }
                    if (!Objects.equals(x.latestVersion, info.latestReleaseVersion)) {
                        LOG.warn("processQuery(): Artifact " + info.artifact + " - latest release by date: " + x.latestVersion + ", latest according to meta data: " + info.latestReleaseVersion);
                    }
                }
            } else {
                versions = info.getVersionsSortedDescending(Artifact::isSnapshotVersion, request.blacklist);
                if (!versions.isEmpty()) {
                    if (versions.size() > 1) {
                        x.secondLatestVersion = versions.get(1);
                    }
                    x.latestVersion = versions.get(0);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("processQuery(): latest release version from metadata: " + info.latestSnapshotVersion);
                        LOG.debug("processQuery(): Calculated latest snapshot version: " + x.latestVersion);
                    }
                    if (!Objects.equals(x.latestVersion, info.latestSnapshotVersion)) {
                        LOG.warn("processQuery(): Artifact " + info.artifact + " - latest SNAPSHOT release by date: " + x.latestVersion + ", latest SNAPSHOT release according to meta data: " + info.latestSnapshotVersion);
                    }
                }
            }
            if (artifact.version == null || x.latestVersion == null) {
                x.updateAvailable = ArtifactResponse.UpdateAvailable.MAYBE;
            } else {
                Optional<Version> currentVersion = info.getVersion(artifact.version);
                currentVersion.ifPresent(version -> {
                    x.currentVersion = version;
                });
                int cmp = Artifact.VERSION_COMPARATOR.compare(artifact.version, x.latestVersion.versionString);
                x.updateAvailable = cmp >= 0 ? ArtifactResponse.UpdateAvailable.NO : ArtifactResponse.UpdateAvailable.YES;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("processQuery(): " + artifact + " <-> " + x.latestVersion + " => " + x.updateAvailable);
        }
        return result;
    }

    public Mode getMode() {
        return this.mode;
    }

    public IBackgroundUpdater getBackgroundUpdater() {
        return this.updater;
    }

    public IVersionTracker getVersionTracker() {
        return this.versionTracker;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.updater != null) {
                this.updater.close();
            }
        }
        finally {
            try {
                if (this.versionTracker != null) {
                    this.versionTracker.close();
                }
            }
            finally {
                if (this.versionStorage != null) {
                    this.versionStorage.close();
                }
            }
        }
    }

    public void setRegisterShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
    }

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

