/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.Blacklist;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionInfo {
    private static final Logger LOG = LogManager.getLogger(VersionInfo.class);
    public Artifact artifact;
    public ZonedDateTime lastRequestDate;
    public ZonedDateTime creationDate;
    public ZonedDateTime lastSuccessDate;
    public ZonedDateTime lastFailureDate;
    public ZonedDateTime lastRepositoryUpdate;
    public Version latestReleaseVersion;
    public Version latestSnapshotVersion;
    public List<Version> versions = new ArrayList<Version>();

    public VersionInfo() {
    }

    public void serialize(BinarySerializer serializer, SerializationFormat format) throws IOException {
        this.artifact.serialize(serializer);
        serializer.writeZonedDateTime(this.lastRequestDate);
        serializer.writeZonedDateTime(this.creationDate);
        serializer.writeZonedDateTime(this.lastSuccessDate);
        serializer.writeZonedDateTime(this.lastFailureDate);
        serializer.writeZonedDateTime(this.lastRepositoryUpdate);
        if (this.latestReleaseVersion != null) {
            serializer.writeBoolean(true);
            this.latestReleaseVersion.serialize(serializer, format);
        } else {
            serializer.writeBoolean(false);
        }
        if (this.latestSnapshotVersion != null) {
            serializer.writeBoolean(true);
            this.latestSnapshotVersion.serialize(serializer, format);
        } else {
            serializer.writeBoolean(false);
        }
        serializer.writeInt(this.versions.size());
        for (Version v : this.versions) {
            v.serialize(serializer, format);
        }
    }

    public static VersionInfo deserialize(BinarySerializer serializer, SerializationFormat fileFormatVersion) throws IOException {
        VersionInfo result = new VersionInfo();
        result.artifact = Artifact.deserialize(serializer);
        result.lastRequestDate = serializer.readZonedDateTime();
        result.creationDate = serializer.readZonedDateTime();
        result.lastSuccessDate = serializer.readZonedDateTime();
        result.lastFailureDate = serializer.readZonedDateTime();
        result.lastRepositoryUpdate = serializer.readZonedDateTime();
        if (serializer.readBoolean()) {
            result.latestReleaseVersion = Version.deserialize(serializer, fileFormatVersion);
        }
        if (serializer.readBoolean()) {
            result.latestSnapshotVersion = Version.deserialize(serializer, fileFormatVersion);
        }
        int size = serializer.readInt();
        result.versions = new ArrayList<Version>(size);
        for (int i = 0; i < size; ++i) {
            result.versions.add(Version.deserialize(serializer, fileFormatVersion));
        }
        return result;
    }

    public boolean hasVersions() {
        return !this.versions.isEmpty();
    }

    public Optional<Version> findLatestSnapshotVersion(Blacklist blacklist) {
        return this.findLatestVersion(Artifact::isSnapshotVersion, blacklist);
    }

    public Optional<Version> findLatestReleaseVersion(Blacklist blacklist) {
        return this.findLatestVersion(Artifact::isReleaseVersion, blacklist);
    }

    public boolean removeVersionsIf(Predicate<Version> p) {
        return this.versions.removeIf(p);
    }

    private Predicate<Version> blacklistPredicate(Blacklist blacklist) {
        return version -> blacklist != null && blacklist.isVersionBlacklisted(this.artifact.groupId, this.artifact.artifactId, version.versionString);
    }

    public List<Version> getVersionsSortedDescending(Predicate<String> versionPredicate, Blacklist blacklist) {
        Predicate<Version> isBlacklisted = this.blacklistPredicate(blacklist);
        ArrayList<Version> result = new ArrayList<Version>();
        for (Version v2 : this.versions) {
            if (!versionPredicate.test(v2.versionString) || isBlacklisted.test(v2)) continue;
            result.add(v2);
        }
        result.sort(Comparator.comparing(v -> v.versionString, Artifact.VERSION_COMPARATOR).reversed());
        return result;
    }

    private Optional<Version> findLatestVersion(Predicate<String> versionPredicate, Blacklist blacklist) {
        List<Version> list = this.getVersionsSortedDescending(versionPredicate, blacklist);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public void addVersion(Version v) {
        for (Version existing : this.versions) {
            if (!existing.versionString.equals(v.versionString)) continue;
            if (v.hasReleaseDate() && !existing.hasReleaseDate()) {
                existing.releaseDate = v.releaseDate;
            }
            return;
        }
        this.versions.add(v);
    }

    public VersionInfo(VersionInfo other) {
        this.artifact = other.artifact == null ? null : other.artifact.copy();
        this.creationDate = other.creationDate;
        this.lastSuccessDate = other.lastSuccessDate;
        this.lastFailureDate = other.lastFailureDate;
        this.versions = other.versions.stream().map(Version::copy).collect(Collectors.toCollection(ArrayList::new));
        this.latestReleaseVersion = other.latestReleaseVersion == null ? null : other.latestReleaseVersion.copy();
        this.latestSnapshotVersion = other.latestSnapshotVersion == null ? null : other.latestSnapshotVersion.copy();
        this.lastRepositoryUpdate = other.lastRepositoryUpdate;
        this.lastRequestDate = other.lastRequestDate;
    }

    public Optional<Boolean> hasReleaseDate(Version versionNumber) {
        return this.hasReleaseDate(versionNumber.versionString);
    }

    public Optional<Boolean> hasReleaseDate(String versionNumber) {
        return this.getVersion(versionNumber).map(Version::hasReleaseDate);
    }

    public Optional<Version> getVersion(String versionNumber) {
        for (Version v : this.versions) {
            if (!v.versionString.equals(versionNumber)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    public ZonedDateTime lastPolledDate() {
        if (this.lastSuccessDate != null && this.lastFailureDate == null) {
            return this.lastSuccessDate;
        }
        if (this.lastSuccessDate == null && this.lastFailureDate != null) {
            return this.lastFailureDate;
        }
        if (this.lastSuccessDate == null && this.lastFailureDate == null) {
            return null;
        }
        return this.lastSuccessDate.compareTo(this.lastFailureDate) > 0 ? this.lastSuccessDate : this.lastFailureDate;
    }

    public VersionInfo copy() {
        return new VersionInfo(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionInfo) {
            return this.artifact.matchesExcludingVersion(((VersionInfo)obj).artifact);
        }
        return false;
    }

    public int hashCode() {
        return this.artifact == null ? 0 : Artifact.hashCode(this.artifact);
    }

    public String toString() {
        return "VersionInfo [artifact=" + this.artifact + ", creationDate=" + this.creationDate + ", lastSuccessDate=" + this.lastSuccessDate + ", lastFailureDate=" + this.lastFailureDate + ", latestReleaseVersion=" + this.latestReleaseVersion + ", latestSnapshotVersion=" + this.latestSnapshotVersion + ", lastRepositoryUpdate=" + this.lastRepositoryUpdate + ", versions=" + this.versions + "]";
    }
}

