/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class Version {
    public String versionString;
    public ZonedDateTime releaseDate;
    public ZonedDateTime firstSeenByServer;

    public Version() {
    }

    public Version(String version) {
        Validate.notBlank((CharSequence)version, (String)"version must not be null or blank", (Object[])new Object[0]);
        this.versionString = version;
    }

    public static Version of(String s) {
        return new Version(s);
    }

    public void serialize(BinarySerializer serializer, SerializationFormat serializationFormat) throws IOException {
        serializer.writeString(this.versionString);
        serializer.writeZonedDateTime(this.releaseDate);
        if (serializationFormat.isAtLeast(SerializationFormat.V3)) {
            serializer.writeZonedDateTime(this.firstSeenByServer);
        }
    }

    public static Version deserialize(BinarySerializer serializer, SerializationFormat serializationFormat) throws IOException {
        Version result = new Version();
        result.versionString = serializer.readString();
        result.releaseDate = serializer.readZonedDateTime();
        if (serializationFormat.isAtLeast(SerializationFormat.V3)) {
            result.firstSeenByServer = serializer.readZonedDateTime();
        }
        return result;
    }

    public static boolean sameVersionNumber(Version v1, Version v2) {
        return Objects.equals(v1.versionString, v2.versionString);
    }

    public static boolean sameFields(Version a, Version b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (!Objects.equals(a.versionString, b.versionString)) {
            return false;
        }
        if (a.releaseDate == null || b.releaseDate == null) {
            return a.releaseDate == b.releaseDate;
        }
        return a.releaseDate.toInstant().equals(b.releaseDate.toInstant());
    }

    public Version(String versionString, ZonedDateTime releaseDate) {
        Validate.notBlank((CharSequence)versionString, (String)"versionString must not be null or blank", (Object[])new Object[0]);
        this.versionString = versionString;
        this.releaseDate = releaseDate;
    }

    public Version(String versionString, ZonedDateTime releaseDate, ZonedDateTime firstSeenByServer) {
        this(versionString, releaseDate);
        Validate.notNull((Object)firstSeenByServer, (String)"firstSeenByServer must not be null", (Object[])new Object[0]);
        this.firstSeenByServer = firstSeenByServer;
    }

    public Version(Version other) {
        Validate.notNull((Object)other, (String)"other must not be null", (Object[])new Object[0]);
        this.versionString = other.versionString;
        this.releaseDate = other.releaseDate;
        this.firstSeenByServer = other.firstSeenByServer;
    }

    public boolean hasReleaseDate() {
        return this.releaseDate != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object v) {
        if (this == v) {
            return true;
        }
        if (!(v instanceof Version)) return false;
        Version ver = (Version)v;
        if (!Objects.equals(this.versionString, ver.versionString)) return false;
        return true;
    }

    public int hashCode() {
        return this.versionString == null ? 0 : this.versionString.hashCode();
    }

    public Version copy() {
        return new Version(this);
    }

    public String toString() {
        return "version '" + this.versionString + "', " + this.releaseDate;
    }
}

