/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.ClientVersion;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum ServerVersion {
    V1("1.0", 1, SerializationFormat.V1),
    V2("2.0", 2, SerializationFormat.V3);

    public String versionString;
    public final short version;
    public final SerializationFormat serializationFormat;

    private ServerVersion(String versionString, short version, SerializationFormat serializationFormat) {
        this.versionString = versionString;
        this.version = version;
        this.serializationFormat = serializationFormat;
        if (Holder.versionsByNumber.put(version, this) != null) {
            throw new IllegalStateException("Duplicate version number: " + version);
        }
    }

    public String toString() {
        return "client V" + this.version;
    }

    public boolean isBefore(ClientVersion other) {
        return this.version < other.version;
    }

    public boolean isAtLeast(ClientVersion other) {
        return this.version >= other.version;
    }

    public static ServerVersion fromVersionNumber(String versionString) {
        return Arrays.stream(ServerVersion.values()).filter(x -> x.versionString.equals(versionString)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown client version: '" + versionString + "'"));
    }

    public static ServerVersion latest() {
        ServerVersion latest = null;
        for (ServerVersion v : ServerVersion.values()) {
            if (latest != null && v.version <= latest.version) continue;
            latest = v;
        }
        return latest;
    }

    private static final class Holder {
        public static final Map<Short, ServerVersion> versionsByNumber = new HashMap<Short, ServerVersion>();

        private Holder() {
        }
    }
}

