/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class RequestsPerHour {
    private final Map<Integer, Integer> counts = new TreeMap<Integer, Integer>();
    private long mostRecentAccess;
    private int previousHour = -1;

    public RequestsPerHour() {
    }

    public RequestsPerHour(RequestsPerHour other) {
        this.counts.putAll(other.counts);
        this.mostRecentAccess = other.mostRecentAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<Integer, Integer> map = this.counts;
        synchronized (map) {
            this.counts.clear();
            this.mostRecentAccess = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestsPerHour createCopy() {
        Map<Integer, Integer> map = this.counts;
        synchronized (map) {
            return new RequestsPerHour(this);
        }
    }

    public void update() {
        this.update(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count needs to be >= 0 ");
        }
        Map<Integer, Integer> map = this.counts;
        synchronized (map) {
            this.mostRecentAccess = System.currentTimeMillis();
            int hour = this.currentHour();
            if (this.previousHour == -1 || this.previousHour != hour) {
                this.counts.compute(hour, (key, existing) -> count);
            } else {
                this.counts.compute(hour, (key, existing) -> existing == null ? count : existing + count);
            }
            this.previousHour = hour;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ZonedDateTime> getMostRecentAccess() {
        Map<Integer, Integer> map = this.counts;
        synchronized (map) {
            return Optional.ofNullable(this.mostRecentAccess == 0L ? null : ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.mostRecentAccess), ZoneId.systemDefault()));
        }
    }

    private int currentHour() {
        return ZonedDateTime.now().getHour();
    }

    public int getCountForCurrentHour() {
        return this.getCountForHour(this.currentHour());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountForLast24Hours() {
        Map<Integer, Integer> map = this.counts;
        synchronized (map) {
            int totalCount = 0;
            int currentHour = this.currentHour();
            for (int i = 0; i < 24; ++i) {
                totalCount += this.getCountForHour(currentHour);
                if (--currentHour >= 0) continue;
                currentHour += 24;
            }
            return totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountForHour(int hour) {
        Map<Integer, Integer> map = this.counts;
        synchronized (map) {
            Integer count = this.counts.get(hour);
            return count == null ? 0 : count;
        }
    }
}

