/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.APIRequest;
import de.codesourcery.versiontracker.common.APIResponse;
import de.codesourcery.versiontracker.common.ArtifactResponse;
import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QueryResponse
extends APIResponse {
    public final List<ArtifactResponse> artifacts = new ArrayList<ArtifactResponse>();

    public QueryResponse() {
        super(APIRequest.Command.QUERY);
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryResponse) {
            QueryResponse o = (QueryResponse)obj;
            if (this.artifacts.size() != o.artifacts.size()) {
                System.out.println(">>>>>>>> Artifact size mismatch");
                return false;
            }
            for (ArtifactResponse a1 : this.artifacts) {
                if (!o.artifacts.stream().noneMatch(x -> x.equals(a1))) continue;
                System.out.println(">>>>>>>> Artifact not found: " + a1);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doSerialize(BinarySerializer serializer, SerializationFormat format) throws IOException {
        serializer.writeInt(this.artifacts.size());
        for (ArtifactResponse resp : this.artifacts) {
            resp.serialize(serializer, format);
        }
    }

    public static APIResponse doDeserialize(BinarySerializer serializer, SerializationFormat format) throws IOException {
        QueryResponse result = new QueryResponse();
        for (int count = serializer.readInt(); count > 0; --count) {
            result.artifacts.add(ArtifactResponse.deserialize(serializer, format));
        }
        return result;
    }
}

