/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.codesourcery.versiontracker.common.APIRequest;
import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.Blacklist;
import de.codesourcery.versiontracker.common.ClientVersion;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QueryRequest
extends APIRequest {
    public List<Artifact> artifacts = new ArrayList<Artifact>();
    public Blacklist blacklist;

    public QueryRequest() {
        this((ClientVersion)null);
    }

    public QueryRequest(@JsonProperty(value="clientVersion") ClientVersion clientVersion) {
        super(APIRequest.Command.QUERY, clientVersion);
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryRequest) {
            QueryRequest o = (QueryRequest)obj;
            if (this.artifacts.size() != o.artifacts.size()) {
                return false;
            }
            for (Artifact a1 : this.artifacts) {
                if (!o.artifacts.stream().noneMatch(x -> x.equals(a1))) continue;
                return false;
            }
            if (this.blacklist == null || o.blacklist == null) {
                return this.blacklist == o.blacklist;
            }
            return this.blacklist.equals(o.blacklist);
        }
        return false;
    }

    @Override
    protected void doSerialize(BinarySerializer serializer, SerializationFormat format) throws IOException {
        serializer.writeInt(this.artifacts.size());
        for (Artifact a : this.artifacts) {
            a.serialize(serializer);
        }
        this.blacklist.serialize(serializer);
    }

    static QueryRequest doDeserialize(BinarySerializer serializer, ClientVersion version) throws IOException {
        QueryRequest result = new QueryRequest(version);
        for (int count = serializer.readInt(); count > 0; --count) {
            Artifact artifact = Artifact.deserialize(serializer);
            result.artifacts.add(artifact);
        }
        result.blacklist = Blacklist.deserialize(serializer);
        return result;
    }
}

