/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.codesourcery.versiontracker.common.APIRequest;
import de.codesourcery.versiontracker.common.ClientVersion;
import de.codesourcery.versiontracker.common.QueryRequest;
import de.codesourcery.versiontracker.common.ServerVersion;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class JSONHelper {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmm").withZone(ZoneId.of("UTC"));

    public static APIRequest parseAPIRequest(String jsonString, ObjectMapper mapper) throws IOException {
        JsonNode tree = mapper.readTree(jsonString);
        String cmd = tree.get("command").asText();
        APIRequest.Command command = APIRequest.Command.fromString(cmd);
        switch (command) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case QUERY: 
        }
        QueryRequest result = (QueryRequest)mapper.readValue(jsonString, QueryRequest.class);
        if (result.clientVersion == null) {
            throw new IOException("Internal error, client version not set - Jackson deserialization failed?");
        }
        return result;
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper result = new ObjectMapper();
        VisibilityChecker checker = result.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE);
        result.setVisibility(checker);
        SimpleModule module = new SimpleModule();
        module.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer());
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        module.addDeserializer(ClientVersion.class, (JsonDeserializer)new StdDeserializer<ClientVersion>(ClientVersion.class){

            public ClientVersion deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
                JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                String clientVersion = node.asText();
                return ClientVersion.fromVersionNumber(clientVersion);
            }
        });
        module.addSerializer(ClientVersion.class, (JsonSerializer)new StdSerializer<ClientVersion>(ClientVersion.class){

            public void serialize(ClientVersion value, JsonGenerator generator, SerializerProvider provider) throws IOException {
                generator.writeFieldName("clientVersion");
                generator.writeString(value.versionString);
            }
        });
        module.addDeserializer(ServerVersion.class, (JsonDeserializer)new StdDeserializer<ServerVersion>(ServerVersion.class){

            public ServerVersion deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
                JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                String clientVersion = node.asText();
                return ServerVersion.fromVersionNumber(clientVersion);
            }
        });
        module.addSerializer(ServerVersion.class, (JsonSerializer)new StdSerializer<ServerVersion>(ServerVersion.class){

            public void serialize(ServerVersion value, JsonGenerator generator, SerializerProvider provider) throws IOException {
                generator.writeString(value.versionString);
            }
        });
        result.registerModule((Module)module);
        result.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return result;
    }

    public static class ZonedDateTimeSerializer
    extends StdSerializer<ZonedDateTime> {
        private static final ZoneId UTC = ZoneId.of("UTC");

        public ZonedDateTimeSerializer() {
            super(ZonedDateTime.class);
        }

        public void serialize(ZonedDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(DATE_FORMATTER.format(value.withZoneSameInstant(UTC)));
        }
    }

    public static class ZonedDateTimeDeserializer
    extends StdDeserializer<ZonedDateTime> {
        public ZonedDateTimeDeserializer() {
            super(ZonedDateTime.class);
        }

        public ZonedDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String text = node.textValue();
            return ZonedDateTime.parse(text, DATE_FORMATTER);
        }
    }
}

