/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.RequestsPerHour;
import de.codesourcery.versiontracker.common.VersionInfo;
import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface IVersionStorage
extends AutoCloseable {
    public static final Logger STORAGE_LOG = LogManager.getLogger(IVersionStorage.class);

    public List<VersionInfo> getAllVersions() throws IOException;

    default public List<VersionInfo> getAllVersions(String groupRegEx, String artifactRegEx) throws IOException {
        Pattern groupPattern = Pattern.compile(groupRegEx);
        Pattern artifactPattern = Pattern.compile(artifactRegEx);
        return this.getAllVersions().stream().filter(v -> groupPattern.matcher(v.artifact.groupId).matches() && artifactPattern.matcher(v.artifact.artifactId).matches()).toList();
    }

    public StorageStatistics getStatistics();

    public void resetStatistics();

    default public List<VersionInfo> getAllStaleVersions(Duration lastSuccessDuration, Duration lastFailureDuration, ZonedDateTime now) throws IOException {
        ArrayList<VersionInfo> result = new ArrayList<VersionInfo>();
        for (VersionInfo info : this.getAllVersions()) {
            if (!IVersionStorage.isStaleVersion(info, lastSuccessDuration, lastFailureDuration, now)) continue;
            result.add(info);
        }
        return result;
    }

    public static boolean isStaleVersion(VersionInfo info, Duration minUpdateDelayAfterSuccess, Duration minUpdateDelayAfterFailure, ZonedDateTime now) {
        boolean isStale;
        if (info.lastPolledDate() == null) {
            isStale = true;
            if (STORAGE_LOG.isDebugEnabled()) {
                STORAGE_LOG.debug("isStaleVersion(): [stale,never successfully polled at all] " + info.artifact);
            }
        } else if (info.lastSuccessDate != null && info.lastFailureDate != null) {
            if (info.lastSuccessDate.isAfter(info.lastFailureDate)) {
                boolean bl = isStale = Duration.between(info.lastSuccessDate, now).compareTo(minUpdateDelayAfterSuccess) > 0;
                if (isStale && STORAGE_LOG.isDebugEnabled()) {
                    STORAGE_LOG.debug("isStaleVersion(): [stale,lastSuccessDate " + info.lastSuccessDate + " is more than " + minUpdateDelayAfterSuccess + " ago] " + info.artifact);
                }
            } else {
                boolean bl = isStale = Duration.between(info.lastFailureDate, now).compareTo(minUpdateDelayAfterFailure) > 0;
                if (isStale && STORAGE_LOG.isDebugEnabled()) {
                    STORAGE_LOG.debug("isStaleVersion(): [stale,lastFailureDate " + info.lastFailureDate + " is more than " + minUpdateDelayAfterFailure + " ago] " + info.artifact);
                }
            }
        } else if (info.lastSuccessDate == null) {
            boolean bl = isStale = Duration.between(info.lastFailureDate, now).compareTo(minUpdateDelayAfterFailure) > 0;
            if (isStale && STORAGE_LOG.isDebugEnabled()) {
                STORAGE_LOG.debug("isStaleVersion(): [stale,lastFailureDate " + info.lastFailureDate + " is more than " + minUpdateDelayAfterFailure + " ago] " + info.artifact);
            }
        } else {
            boolean bl = isStale = Duration.between(info.lastSuccessDate, now).compareTo(minUpdateDelayAfterSuccess) > 0;
            if (isStale && STORAGE_LOG.isDebugEnabled()) {
                STORAGE_LOG.debug("isStaleVersion(): [stale,lastSuccessDate " + info.lastSuccessDate + " is more than " + minUpdateDelayAfterSuccess + " ago] " + info.artifact);
            }
        }
        return isStale;
    }

    public void saveOrUpdate(VersionInfo var1) throws IOException;

    default public Optional<VersionInfo> getVersionInfo(Artifact artifact) throws IOException {
        return this.getAllVersions().stream().filter(item -> item.artifact.matchesExcludingVersion(artifact)).findFirst();
    }

    default public void updateLastRequestDate(Artifact artifact, ZonedDateTime date) throws IOException {
        Optional<VersionInfo> existing = this.getVersionInfo(artifact);
        if (existing.isPresent()) {
            existing.get().lastRequestDate = date;
            this.saveOrUpdate(existing.get());
        }
    }

    public void saveOrUpdate(List<VersionInfo> var1) throws IOException;

    public static final class StorageStatistics {
        public ZonedDateTime lastStatisticsReset = ZonedDateTime.now();
        public int totalArtifactCount;
        public int totalVersionCount;
        public long storageSizeInBytes;
        public RequestsPerHour reads = new RequestsPerHour();
        public RequestsPerHour writes = new RequestsPerHour();
        public ZonedDateTime mostRecentRequested = null;
        public ZonedDateTime mostRecentFailure = null;
        public ZonedDateTime mostRecentSuccess = null;

        public StorageStatistics() {
        }

        public void reset() {
            this.totalArtifactCount = 0;
            this.totalVersionCount = 0;
            this.storageSizeInBytes = 0L;
            this.reads.reset();
            this.writes.reset();
            this.mostRecentRequested = null;
            this.mostRecentFailure = null;
            this.mostRecentSuccess = null;
            this.lastStatisticsReset = ZonedDateTime.now();
        }

        public Optional<ZonedDateTime> mostRecentRequested() {
            return Optional.ofNullable(this.mostRecentRequested);
        }

        public Optional<ZonedDateTime> mostRecentFailure() {
            return Optional.ofNullable(this.mostRecentFailure);
        }

        public Optional<ZonedDateTime> mostRecentSuccess() {
            return Optional.ofNullable(this.mostRecentSuccess);
        }

        public StorageStatistics(StorageStatistics other) {
            this.totalArtifactCount = other.totalArtifactCount;
            this.totalVersionCount = other.totalVersionCount;
            this.storageSizeInBytes = other.storageSizeInBytes;
            this.mostRecentRequested = other.mostRecentRequested;
            this.mostRecentFailure = other.mostRecentFailure;
            this.mostRecentSuccess = other.mostRecentSuccess;
            this.reads = other.reads.createCopy();
            this.writes = other.writes.createCopy();
            this.lastStatisticsReset = other.lastStatisticsReset;
        }

        public StorageStatistics createCopy() {
            return new StorageStatistics(this);
        }
    }
}

