/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.RequestsPerHour;
import de.codesourcery.versiontracker.common.VersionInfo;
import de.codesourcery.versiontracker.common.server.ConfigurationProvider;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

public interface IVersionProvider {
    public Statistics getStatistics();

    public void resetStatistics();

    public void setConfigurationProvider(ConfigurationProvider var1);

    public UpdateResult update(VersionInfo var1, boolean var2) throws IOException;

    public static final class Statistics {
        public volatile ZonedDateTime lastStatisticsReset = ZonedDateTime.now();
        public final RequestsPerHour metaDataRequests;
        public final RequestsPerHour apiRequests;
        public final Map<Integer, Integer> httpRequestCountByResponseCode = new HashMap<Integer, Integer>();

        public Statistics() {
            this.metaDataRequests = new RequestsPerHour();
            this.apiRequests = new RequestsPerHour();
        }

        public Statistics(Statistics other) {
            this.metaDataRequests = new RequestsPerHour(other.metaDataRequests);
            this.apiRequests = new RequestsPerHour(other.apiRequests);
            this.lastStatisticsReset = other.lastStatisticsReset;
            this.httpRequestCountByResponseCode.putAll(other.httpRequestCountByResponseCode);
        }

        public void reset() {
            this.lastStatisticsReset = ZonedDateTime.now();
            this.metaDataRequests.reset();
            this.apiRequests.reset();
            this.httpRequestCountByResponseCode.clear();
        }

        public Statistics createCopy() {
            return new Statistics(this);
        }
    }

    public static enum UpdateResult {
        ARTIFACT_UNKNOWN,
        ARTIFACT_VERSION_NOT_FOUND,
        NO_CHANGES_ON_SERVER,
        UPDATED,
        BLACKLISTED,
        ERROR;

    }
}

