/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.BinarySerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Blacklist {
    private static final NeverMatcher NEVER_MATCHER = new NeverMatcher();
    private final List<VersionStringMatcher> globalIgnores = new ArrayList<VersionStringMatcher>();
    private final Map<String, List<VersionStringMatcher>> groupIdIgnores = new HashMap<String, List<VersionStringMatcher>>();
    private final Map<String, Map<String, List<VersionStringMatcher>>> artifactIgnores = new HashMap<String, Map<String, List<VersionStringMatcher>>>();

    public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    public boolean isNotEmpty() {
        return !this.globalIgnores.isEmpty() || !this.groupIdIgnores.isEmpty() || !this.artifactIgnores.isEmpty();
    }

    public void clear() {
        this.globalIgnores.clear();
        this.groupIdIgnores.clear();
        this.artifactIgnores.clear();
    }

    public boolean equals(Object other) {
        if (other instanceof Blacklist) {
            Blacklist o = (Blacklist)other;
            if (!Blacklist.equals(this.globalIgnores, o.globalIgnores)) {
                return false;
            }
            if (!Blacklist.equals(this.groupIdIgnores, o.groupIdIgnores)) {
                return false;
            }
            if (this.artifactIgnores.size() != o.artifactIgnores.size()) {
                return false;
            }
            for (Map.Entry<String, Map<String, List<VersionStringMatcher>>> entry1 : this.artifactIgnores.entrySet()) {
                Map<String, List<VersionStringMatcher>> map2;
                String key = entry1.getKey();
                Map<String, List<VersionStringMatcher>> map1 = entry1.getValue();
                if (Blacklist.equals(map1, map2 = o.artifactIgnores.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void serialize(BinarySerializer serializer) throws IOException {
        serializer.writeInt(this.globalIgnores.size());
        for (VersionStringMatcher versionStringMatcher : this.globalIgnores) {
            versionStringMatcher.serialize(serializer);
        }
        serializer.writeInt(this.groupIdIgnores.size());
        for (Map.Entry entry : this.groupIdIgnores.entrySet()) {
            this.serializeMapEntry(entry, serializer);
        }
        serializer.writeInt(this.artifactIgnores.size());
        for (Map.Entry entry : this.artifactIgnores.entrySet()) {
            serializer.writeString((String)entry.getKey());
            Map map = (Map)entry.getValue();
            serializer.writeInt(map.size());
            for (Map.Entry<String, List<VersionStringMatcher>> entry2 : map.entrySet()) {
                this.serializeMapEntry(entry2, serializer);
            }
        }
    }

    private void serializeMapEntry(Map.Entry<String, List<VersionStringMatcher>> entry, BinarySerializer serializer) throws IOException {
        serializer.writeString(entry.getKey());
        serializer.writeInt(entry.getValue().size());
        for (VersionStringMatcher matcher : entry.getValue()) {
            matcher.serialize(serializer);
        }
    }

    public boolean isAllVersionsBlacklisted(String groupId, String artifactId) {
        if (Blacklist.containsNeverMatcher(this.globalIgnores)) {
            return true;
        }
        if (Blacklist.containsNeverMatcher(this.getMatchersForGroupId(groupId))) {
            return true;
        }
        Map<String, List<VersionStringMatcher>> map1 = this.artifactIgnores.get(groupId);
        return map1 != null && Blacklist.containsNeverMatcher(map1.get(artifactId));
    }

    public void addIgnoredVersion(String pattern, VersionMatcher matcher) {
        VersionStringMatcher newMatcher = VersionStringMatcher.createMatcher(pattern, matcher);
        if (!this.globalIgnores.contains(newMatcher)) {
            this.globalIgnores.add(newMatcher);
        }
    }

    public void addIgnoredVersion(String groupId, String pattern, VersionMatcher matcher) {
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be NULL or blank", (Object[])new Object[0]);
        List existing = this.groupIdIgnores.computeIfAbsent(groupId, k -> new ArrayList());
        VersionStringMatcher newMatcher = VersionStringMatcher.createMatcher(pattern, matcher);
        if (!existing.contains(newMatcher)) {
            existing.add(newMatcher);
        }
    }

    public void addIgnoredVersion(String groupId, String artifactId, String pattern, VersionMatcher matcher) {
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be NULL or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId must not be NULL or blank", (Object[])new Object[0]);
        Map existing = this.artifactIgnores.computeIfAbsent(groupId, k -> new HashMap());
        List existingSet = existing.computeIfAbsent(artifactId, k -> new ArrayList());
        VersionStringMatcher newMatcher = VersionStringMatcher.createMatcher(pattern, matcher);
        if (!existingSet.contains(newMatcher)) {
            existingSet.add(newMatcher);
        }
    }

    public boolean isArtifactBlacklisted(Artifact artifact) {
        Validate.notBlank((CharSequence)artifact.groupId, (String)"group ID must not be NULL or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifact.artifactId, (String)"artifact ID must not be NULL or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifact.version, (String)"artifact version must not be NULL or blank", (Object[])new Object[0]);
        String version = artifact.version;
        if (StringUtils.isNotBlank((CharSequence)version)) {
            for (VersionStringMatcher versionStringMatcher : this.globalIgnores) {
                if (!versionStringMatcher.isIgnoredVersion(version)) continue;
                return true;
            }
            List<VersionStringMatcher> groupOnlyMatchers = this.getMatchersForGroupId(artifact.groupId);
            for (VersionStringMatcher m : groupOnlyMatchers) {
                if (!m.isIgnoredVersion(version)) continue;
                return true;
            }
            Map<String, List<VersionStringMatcher>> map = this.artifactIgnores.get(artifact.groupId);
            if (map != null) {
                List<VersionStringMatcher> matchers = map.get(artifact.artifactId);
                for (VersionStringMatcher m : matchers) {
                    if (!m.isIgnoredVersion(version)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<VersionStringMatcher> getMatchersForGroupId(String artifactGroupId) {
        String mostSpecificMatch = null;
        for (String expectedGroupId : this.groupIdIgnores.keySet()) {
            boolean matches = artifactGroupId.equals(expectedGroupId) || artifactGroupId.startsWith(expectedGroupId + ".");
            if (!matches || mostSpecificMatch != null && expectedGroupId.length() <= mostSpecificMatch.length()) continue;
            mostSpecificMatch = expectedGroupId;
        }
        return mostSpecificMatch == null ? Collections.emptyList() : this.groupIdIgnores.get(mostSpecificMatch);
    }

    public boolean isVersionBlacklisted(String groupId, String artifactId, String version) {
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be NULL or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId must not be NULL or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)version, (String)"version must not be NULL or blank", (Object[])new Object[0]);
        for (VersionStringMatcher versionStringMatcher : this.globalIgnores) {
            if (!versionStringMatcher.isIgnoredVersion(version)) continue;
            return true;
        }
        List<VersionStringMatcher> list = this.getMatchersForGroupId(groupId);
        for (VersionStringMatcher m : list) {
            if (!m.isIgnoredVersion(version)) continue;
            return true;
        }
        Map<String, List<VersionStringMatcher>> map = this.artifactIgnores.get(groupId);
        if (map != null && (list = map.get(artifactId)) != null) {
            for (VersionStringMatcher m : list) {
                if (!m.isIgnoredVersion(version)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean equals(Map<String, List<VersionStringMatcher>> m1, Map<String, List<VersionStringMatcher>> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<String, List<VersionStringMatcher>> entry : m1.entrySet()) {
            List<VersionStringMatcher> l2;
            List<VersionStringMatcher> l1 = entry.getValue();
            if (Blacklist.equals(l1, l2 = m2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(List<VersionStringMatcher> l1, List<VersionStringMatcher> l2) {
        if (l1 == null || l2 == null) {
            return l1 == l2;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (VersionStringMatcher m1 : l1) {
            if (!l2.stream().noneMatch(x -> x.equals(m1))) continue;
            return false;
        }
        return true;
    }

    private static void deserializeMapEntry(Map<String, List<VersionStringMatcher>> map, BinarySerializer serializer) throws IOException {
        int count;
        String key = serializer.readString();
        ArrayList<VersionStringMatcher> list = new ArrayList<VersionStringMatcher>(count);
        for (count = serializer.readInt(); count > 0; --count) {
            list.add(VersionStringMatcher.deserialize(serializer));
        }
        map.put(key, list);
    }

    public static Blacklist deserialize(BinarySerializer serializer) throws IOException {
        int count;
        Blacklist result = new Blacklist();
        for (count = serializer.readInt(); count > 0; --count) {
            result.globalIgnores.add(VersionStringMatcher.deserialize(serializer));
        }
        for (count = serializer.readInt(); count > 0; --count) {
            Blacklist.deserializeMapEntry(result.groupIdIgnores, serializer);
        }
        for (count = serializer.readInt(); count > 0; --count) {
            int count2;
            String key = serializer.readString();
            HashMap<String, List<VersionStringMatcher>> map = new HashMap<String, List<VersionStringMatcher>>(count2);
            for (count2 = serializer.readInt(); count2 > 0; --count2) {
                Blacklist.deserializeMapEntry(map, serializer);
            }
            result.artifactIgnores.put(key, map);
        }
        return result;
    }

    private static boolean containsNeverMatcher(List<VersionStringMatcher> list) {
        return list != null && list.contains(NEVER_MATCHER);
    }

    public static class VersionStringMatcher {
        public final String pattern;
        public final VersionMatcher type;
        public volatile transient Pattern compiledPattern;

        private VersionStringMatcher(String pattern, VersionMatcher type) {
            Validate.notBlank((CharSequence)pattern, (String)"pattern must not be NULL or blank", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)type), (String)"type must not be NULL", (Object[])new Object[0]);
            this.pattern = pattern;
            this.type = type;
            if (type == VersionMatcher.REGEX) {
                Pattern pattern2 = Pattern.compile(pattern);
            }
        }

        public boolean equals(Object other) {
            if (other != null && this.getClass() == other.getClass()) {
                VersionStringMatcher o = (VersionStringMatcher)other;
                return Objects.equals(this.pattern, o.pattern) && Objects.equals((Object)this.type, (Object)o.type);
            }
            return false;
        }

        public void serialize(BinarySerializer serializer) throws IOException {
            serializer.writeString(this.type.text);
            serializer.writeString(this.pattern);
        }

        public String toString() {
            return "IgnoreVersion[" + this.type + "] = '" + this.pattern + "'";
        }

        public int hashCode() {
            return 31 * (31 + this.pattern.hashCode()) + this.type.hashCode();
        }

        public boolean isIgnoredVersion(String s) {
            if (s == null) {
                return false;
            }
            if (this.type == VersionMatcher.EXACT) {
                return Objects.equals(s, this.pattern);
            }
            Pattern pat = this.compiledPattern;
            if (pat == null) {
                this.compiledPattern = pat = Pattern.compile(this.pattern);
            }
            return pat.matcher(s).matches();
        }

        @JsonCreator
        public static VersionStringMatcher createMatcher(@JsonProperty(value="pattern") String pattern, @JsonProperty(value="type") VersionMatcher type) {
            Validate.notBlank((CharSequence)pattern, (String)"pattern must not be NULL or blank", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)type), (String)"type must not be NULL", (Object[])new Object[0]);
            if (VersionMatcher.REGEX.equals((Object)type) && ".*".equals(pattern)) {
                return NEVER_MATCHER;
            }
            return new VersionStringMatcher(pattern, type);
        }

        public static VersionStringMatcher deserialize(BinarySerializer serializer) throws IOException {
            String type = serializer.readString();
            String pattern = serializer.readString();
            return VersionStringMatcher.createMatcher(pattern, VersionMatcher.fromString(type));
        }
    }

    public static enum VersionMatcher {
        EXACT("exact"),
        REGEX("regex");

        public final String text;

        private VersionMatcher(String text) {
            this.text = text;
        }

        public static VersionMatcher fromString(String s) {
            return switch (s.toLowerCase()) {
                case "exact" -> EXACT;
                case "regex" -> REGEX;
                default -> throw new IllegalArgumentException("Unsupported version matcher type: '" + s + "'");
            };
        }
    }

    public static final class NeverMatcher
    extends VersionStringMatcher {
        public NeverMatcher() {
            super(".*", VersionMatcher.REGEX);
        }

        @Override
        public boolean isIgnoredVersion(String s) {
            return true;
        }
    }
}

