/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinarySerializer
implements AutoCloseable,
Closeable {
    protected static final Logger LOG = LogManager.getLogger(BinarySerializer.class);
    protected static final ZoneId UTC = ZoneId.of("UTC");
    static final boolean TRACK_OFFSET = false;
    public final IBuffer buffer;

    public BinarySerializer(IBuffer buffer) {
        this.buffer = buffer;
    }

    public boolean isEOF() throws IOException {
        return this.buffer.isEOF();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public void writeArray(byte[] value) throws IOException {
        this.writeInt(value.length);
        this.buffer.write(value);
    }

    public byte[] readArray() throws IOException {
        byte[] result = new byte[this.readInt()];
        this.buffer.read(result);
        return result;
    }

    public void writeBytes(byte[] buffer) throws IOException {
        this.writeBytes(buffer, 0, buffer.length);
    }

    public void writeBytes(byte[] data, int offset, int length) throws IOException {
        this.buffer.write(data, offset, length);
    }

    public void writeByte(byte value) throws IOException {
        this.buffer.write((byte)(value & 0xFF));
    }

    public void readBytes(byte[] destination) throws IOException {
        this.buffer.read(destination);
    }

    public byte readByte() throws IOException {
        return this.buffer.read();
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeByte((byte)(value ? 18 : 52));
    }

    public boolean readBoolean() throws IOException {
        byte v = this.readByte();
        if (v == 18) {
            return true;
        }
        if (v == 52) {
            return false;
        }
        throw new IOException("Expected a boolean value but got 0x" + Integer.toHexString(v & 0xFF));
    }

    public void writeShort(short value) throws IOException {
        this.writeByte((byte)(value >> 8 & 0xFF));
        this.writeByte((byte)(value & 0xFF));
    }

    public short readShort() throws IOException {
        int hi = this.readByte() << 8 & 0xFF00;
        int lo = this.readByte() & 0xFF;
        return (short)(hi | lo);
    }

    public void writeInt(int value) throws IOException {
        this.writeShort((short)(value >> 16 & 0xFFFF));
        this.writeShort((short)(value & 0xFFFF));
    }

    public int readInt() throws IOException {
        int hi = this.readShort() << 16 & 0xFFFF0000;
        int lo = this.readShort() & 0xFFFF;
        return hi | lo;
    }

    public void writeLong(long value) throws IOException {
        this.writeInt((int)(value >> 32));
        this.writeInt((int)value);
    }

    public long readLong() throws IOException {
        long hi = (long)this.readInt() << 32;
        long lo = (long)this.readInt() & 0xFFFFFFFFL;
        return hi | lo;
    }

    public void writeString(String s) throws IOException {
        if (s == null) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)1);
        this.writeArray(s.getBytes(StandardCharsets.UTF_8));
    }

    public String readString() throws IOException {
        if (this.readByte() == 0) {
            return null;
        }
        return new String(this.readArray(), StandardCharsets.UTF_8);
    }

    public void writeZonedDateTime(ZonedDateTime dt) throws IOException {
        if (dt == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            long millis = dt.toEpochSecond() * 1000L + (long)(dt.getNano() / 1000000);
            this.writeLong(millis);
        }
    }

    public ZonedDateTime readZonedDateTime() throws IOException {
        boolean isPresent = this.readBoolean();
        if (!isPresent) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(this.readLong());
        return ZonedDateTime.ofInstant(instant, UTC);
    }

    public static interface IBuffer
    extends Closeable {
        public int maybeReadByte() throws IOException;

        public byte read() throws IOException;

        public void read(byte[] var1) throws IOException;

        public boolean isEOF() throws IOException;

        public void write(byte var1) throws IOException;

        public void write(byte[] var1, int var2, int var3) throws IOException;

        public void write(byte[] var1) throws IOException;

        public void skip(int var1) throws IOException;

        @Override
        public void close() throws IOException;

        public static IBuffer wrap(byte[] data) throws IOException {
            return IBuffer.wrap(new ByteArrayInputStream(data));
        }

        public static IBuffer wrap(InputStream in) throws IOException {
            return new InBuffer(in);
        }

        public static IBuffer wrap(OutputStream out) {
            return new OutBuffer(out);
        }
    }

    protected static final class OutBuffer
    implements IBuffer {
        private final OutputStream out;
        public int offset;

        public OutBuffer(OutputStream out) {
            Validate.notNull((Object)out, (String)"out must not be NULL", (Object[])new Object[0]);
            this.out = out;
        }

        @Override
        public void skip(int bytesToSkip) {
            throw new UnsupportedOperationException("method not supported: skip(int)");
        }

        @Override
        public int maybeReadByte() {
            throw new UnsupportedOperationException("method not supported: maybeReadByte()");
        }

        @Override
        public byte read() {
            throw new UnsupportedOperationException("method not supported: read()");
        }

        @Override
        public void read(byte[] destination) {
            throw new UnsupportedOperationException("method not supported: read(byte[])");
        }

        @Override
        public boolean isEOF() {
            throw new UnsupportedOperationException("method not supported: isEOF()");
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        @Override
        public void write(byte value) throws IOException {
            this.out.write(value);
        }

        @Override
        public void write(byte[] array) throws IOException {
            this.out.write(array);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        public String toString() {
            return "OutBuffer";
        }
    }

    protected static final class InBuffer
    implements IBuffer {
        private final InputStream in;
        private int next;
        public int offset;

        public InBuffer(InputStream in) throws IOException {
            Validate.notNull((Object)in, (String)"in must not be NULL", (Object[])new Object[0]);
            this.in = in;
            this.next = in.read();
        }

        @Override
        public void skip(int bytesToSkip) throws IOException {
            if (bytesToSkip == 0) {
                return;
            }
            if (bytesToSkip < 0) {
                throw new IllegalArgumentException("A negative offset is not allowed : " + bytesToSkip);
            }
            if (this.next == -1) {
                throw new EOFException("Premature end of input, expected " + bytesToSkip + " more bytes");
            }
            this.in.skipNBytes(bytesToSkip - 1);
        }

        @Override
        public int maybeReadByte() throws IOException {
            int result = this.next;
            if (result != -1) {
                this.next = this.in.read();
            }
            return result;
        }

        @Override
        public byte read() throws IOException {
            int result = this.maybeReadByte();
            if (result == -1) {
                throw new EOFException("Premature end of input, expected at least one more byte");
            }
            return (byte)result;
        }

        @Override
        public void read(byte[] destination) throws IOException {
            if (destination.length > 1) {
                int result = this.next;
                if (result == -1) {
                    throw new EOFException();
                }
                destination[0] = (byte)result;
                int expected = destination.length - 1;
                int bytesRead = this.in.read(destination, 1, expected);
                if (bytesRead != expected) {
                    throw new EOFException("Expected " + destination.length + " bytes but got only " + (1 + bytesRead));
                }
                this.next = this.in.read();
            } else if (destination.length == 1) {
                destination[0] = this.read();
            }
        }

        private String asHex(int value, int padLen) {
            String s = Integer.toHexString(value);
            s = StringUtils.leftPad((String)s, (int)padLen, (char)'0');
            return "0x" + s;
        }

        @Override
        public boolean isEOF() {
            return this.next == -1;
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            throw new UnsupportedOperationException("not supported: write(byte[],int,int)");
        }

        @Override
        public void write(byte value) {
            throw new UnsupportedOperationException("not supported: write(byte)");
        }

        @Override
        public void write(byte[] value) {
            throw new UnsupportedOperationException("not supported: write(byte[])");
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public String toString() {
            return "InBuffer @ 0x" + Integer.toHexString(this.offset);
        }
    }
}

