/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.Artifact;
import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.Version;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.IOException;
import java.util.Objects;

public class ArtifactResponse {
    public Artifact artifact;
    public Version currentVersion;
    public Version secondLatestVersion;
    public Version latestVersion;
    public UpdateAvailable updateAvailable;

    public boolean equals(Object obj) {
        if (obj instanceof ArtifactResponse) {
            ArtifactResponse o = (ArtifactResponse)obj;
            if (!Objects.equals(this.artifact, o.artifact)) {
                return false;
            }
            if (this.currentVersion == null || o.currentVersion == null ? this.currentVersion != o.currentVersion : !Version.sameFields(this.currentVersion, o.currentVersion)) {
                return false;
            }
            if (this.latestVersion == null || o.latestVersion == null ? this.latestVersion != o.latestVersion : !Version.sameFields(this.latestVersion, o.latestVersion)) {
                return false;
            }
            return Objects.equals((Object)this.updateAvailable, (Object)o.updateAvailable);
        }
        return false;
    }

    public void serialize(BinarySerializer serializer, SerializationFormat fileFormat) throws IOException {
        this.artifact.serialize(serializer);
        if (this.currentVersion != null) {
            serializer.writeBoolean(true);
            this.currentVersion.serialize(serializer, fileFormat);
        } else {
            serializer.writeBoolean(false);
        }
        if (this.latestVersion != null) {
            serializer.writeBoolean(true);
            this.latestVersion.serialize(serializer, fileFormat);
        } else {
            serializer.writeBoolean(false);
        }
        if (fileFormat.isAtLeast(SerializationFormat.V3)) {
            if (this.secondLatestVersion != null) {
                serializer.writeBoolean(true);
                this.secondLatestVersion.serialize(serializer, fileFormat);
            } else {
                serializer.writeBoolean(false);
            }
        }
        serializer.writeString(this.updateAvailable == null ? null : this.updateAvailable.text);
    }

    public static ArtifactResponse deserialize(BinarySerializer serializer, SerializationFormat fileFormat) throws IOException {
        String updAvailable;
        ArtifactResponse response = new ArtifactResponse();
        response.artifact = Artifact.deserialize(serializer);
        boolean isPresent = serializer.readBoolean();
        if (isPresent) {
            response.currentVersion = Version.deserialize(serializer, fileFormat);
        }
        if (isPresent = serializer.readBoolean()) {
            response.latestVersion = Version.deserialize(serializer, fileFormat);
        }
        if (fileFormat.isAtLeast(SerializationFormat.V3) && (isPresent = serializer.readBoolean())) {
            response.secondLatestVersion = Version.deserialize(serializer, fileFormat);
        }
        response.updateAvailable = (updAvailable = serializer.readString()) == null ? null : UpdateAvailable.fromString(updAvailable);
        return response;
    }

    public String toString() {
        return "ArtifactResponse[ updateAvailable: " + this.updateAvailable + ", current_version: " + this.currentVersion + ", latest_version: " + this.latestVersion + ", 2nd_latest_version: " + this.secondLatestVersion + ", artifact: " + this.artifact + " ]";
    }

    public boolean hasCurrentVersion() {
        return this.currentVersion != null;
    }

    public boolean hasLatestVersion() {
        return this.latestVersion != null;
    }

    public static enum UpdateAvailable {
        YES("yes"),
        NO("no"),
        MAYBE("maybe"),
        NOT_FOUND("not_found");

        public final String text;

        private UpdateAvailable(String text) {
            this.text = text;
        }

        public static UpdateAvailable fromString(String s) {
            for (UpdateAvailable v : UpdateAvailable.values()) {
                if (!v.text.equals(s)) continue;
                return v;
            }
            return NOT_FOUND;
        }
    }
}

