/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.Validate;

public class ArtifactMap<T> {
    private Map<String, Map<String, T>> data = new HashMap<String, Map<String, T>>();
    private int size;

    public ArtifactMap() {
    }

    public ArtifactMap(ArtifactMap<T> other) {
        this.data = new HashMap<String, Map<String, T>>(other.data);
        this.size = other.size;
    }

    public void visitValues(Consumer<T> visitor) {
        Validate.notNull(visitor, (String)"visitor must not be NULL", (Object[])new Object[0]);
        for (Map.Entry<String, Map<String, T>> mapEntries : this.data.entrySet()) {
            for (Map.Entry<String, T> entries2 : mapEntries.getValue().entrySet()) {
                visitor.accept(entries2.getValue());
            }
        }
    }

    public T remove(String groupId, String artifactId) {
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be NULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId must not be NULL", (Object[])new Object[0]);
        T result = null;
        Map<String, T> map = this.data.get(groupId);
        if (map != null && (result = (T)map.remove(artifactId)) != null) {
            --this.size;
            if (this.size < 0) {
                throw new IllegalStateException("Size should never become negative");
            }
        }
        return result;
    }

    public Stream<T> stream() {
        Spliterator it = new Spliterator<T>(){
            private final Iterator<Map.Entry<String, Map<String, T>>> it1;
            private Iterator<Map.Entry<String, T>> it2;
            {
                this.it1 = ArtifactMap.this.data.entrySet().iterator();
            }

            private T next() {
                if (this.it2 != null && this.it2.hasNext()) {
                    return this.it2.next().getValue();
                }
                if (this.it1.hasNext()) {
                    this.it2 = this.it1.next().getValue().entrySet().iterator();
                    if (this.it2.hasNext()) {
                        return this.it2.next().getValue();
                    }
                }
                return null;
            }

            @Override
            public int characteristics() {
                return 0;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                Object value = this.next();
                if (value != null) {
                    consumer.accept(value);
                }
                return value != null;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }
        };
        return StreamSupport.stream(it, true);
    }

    public void clear() {
        this.data = new HashMap<String, Map<String, T>>();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean contains(String groupId, String artifactId) {
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be NULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId must not be NULL", (Object[])new Object[0]);
        Map<String, T> map = this.data.get(groupId);
        return map != null && map.containsKey(artifactId);
    }

    public T put(String groupId, String artifactId, T value) {
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be NULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId must not be NULL", (Object[])new Object[0]);
        Validate.notNull(value, (String)"value must not be NULL", (Object[])new Object[0]);
        Map map = this.data.computeIfAbsent(groupId, k -> new HashMap());
        T existing = map.put(artifactId, value);
        if (existing == null) {
            ++this.size;
        }
        return existing;
    }

    public T get(String groupId, String artifactId) {
        Validate.notBlank((CharSequence)groupId, (String)"groupId must not be NULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)artifactId, (String)"artifactId must not be NULL", (Object[])new Object[0]);
        Map<String, T> map = this.data.get(groupId);
        return map != null ? (T)map.get(artifactId) : null;
    }

    public void putAll(ArtifactMap<T> other) {
        for (Map.Entry entry : other.data.entrySet()) {
            Map existing = this.data.computeIfAbsent(entry.getKey(), k -> new HashMap(((Map)entry.getValue()).size()));
            existing.putAll(entry.getValue());
        }
    }
}

