/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.BinarySerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Artifact {
    private static final String[] EMPTY_ARRAY = new String[0];
    public static final Comparator<String> VERSION_COMPARATOR = (a, b) -> {
        String[] partsA = Artifact.splitVersionNumber(a);
        String[] partsB = Artifact.splitVersionNumber(b);
        int min = Math.min(partsA.length, partsB.length);
        int result = 0;
        for (int i = 0; i < min; ++i) {
            int tmp;
            try {
                tmp = Integer.compare(Integer.parseInt(partsA[i]), Integer.parseInt(partsB[i]));
            }
            catch (Exception e) {
                tmp = partsA[i].compareTo(partsB[i]);
            }
            if (tmp == 0) continue;
            return tmp;
        }
        if (partsA.length == partsB.length) {
            return result;
        }
        if (partsA.length > partsB.length) {
            return 1;
        }
        return -1;
    };
    public String groupId;
    public String version;
    public String artifactId;
    public String classifier;
    public String type;

    public Artifact() {
    }

    public Artifact(Artifact artifact) {
        this.groupId = artifact.groupId;
        this.version = artifact.version;
        this.artifactId = artifact.artifactId;
        this.classifier = artifact.classifier;
        this.type = artifact.type;
    }

    public Artifact(String groupId, String artifactId, String version, String classifier, String type) {
        this.groupId = groupId;
        this.version = version;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.type = type;
    }

    public void serialize(BinarySerializer serializer) throws IOException {
        serializer.writeString(this.groupId);
        serializer.writeString(this.version);
        serializer.writeString(this.artifactId);
        serializer.writeString(this.classifier);
        serializer.writeString(this.type);
    }

    public static Artifact deserialize(BinarySerializer serializer) throws IOException {
        Artifact a = new Artifact();
        a.groupId = serializer.readString();
        a.version = serializer.readString();
        a.artifactId = serializer.readString();
        a.classifier = serializer.readString();
        a.type = serializer.readString();
        return a;
    }

    public int hashCode() {
        int result = 31 + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return 31 * result + (this.version == null ? 0 : this.version.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Artifact) {
            Artifact a = (Artifact)obj;
            return Objects.equals(this.groupId, a.groupId) && Objects.equals(this.artifactId, a.artifactId) && Objects.equals(this.classifier, a.classifier) && Objects.equals(this.type, a.type) && Objects.equals(this.version, a.version);
        }
        return false;
    }

    public boolean hasSnapshotVersion() {
        return Artifact.isSnapshotVersion(this.version);
    }

    public boolean hasReleaseVersion() {
        return Artifact.isReleaseVersion(this.version);
    }

    public static boolean isReleaseVersion(String version) {
        return !Artifact.isSnapshotVersion(version);
    }

    public static boolean isSnapshotVersion(String version) {
        String[] parts = Artifact.splitVersionNumber(version);
        return parts.length > 0 && parts[parts.length - 1].startsWith("-");
    }

    public static String[] splitVersionNumber(String number) {
        if (number == null || number.trim().isEmpty()) {
            return EMPTY_ARRAY;
        }
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int len = number.length();
        for (int i = 0; i < len; ++i) {
            char c = number.charAt(i);
            if (Character.isDigit(c)) {
                buffer.append(c);
                continue;
            }
            if (!buffer.isEmpty()) {
                parts.add(buffer.toString());
                buffer.setLength(0);
            }
            if (c == '.') continue;
            parts.add(number.substring(i));
            break;
        }
        if (!buffer.isEmpty()) {
            parts.add(buffer.toString());
        }
        return parts.toArray(new String[0]);
    }

    public Artifact copy() {
        return new Artifact(this);
    }

    public boolean matchesExcludingVersion(Artifact other) {
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.type, other.type);
    }

    public static int hashCode(Artifact a) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (a.artifactId == null ? 0 : a.artifactId.hashCode());
        result = 31 * result + (a.classifier == null ? 0 : a.classifier.hashCode());
        result = 31 * result + (a.groupId == null ? 0 : a.groupId.hashCode());
        result = 31 * result + (a.type == null ? 0 : a.type.hashCode());
        return result;
    }

    public String toString() {
        if (this.classifier == null) {
            return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.type;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.type + ":" + this.classifier;
    }

    public boolean hasClassifier() {
        return StringUtils.isNotBlank((CharSequence)this.classifier);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

