/*
 * Decompiled with CFR 0.152.
 */
package de.codesourcery.versiontracker.common;

import de.codesourcery.versiontracker.common.APIRequest;
import de.codesourcery.versiontracker.common.BinarySerializer;
import de.codesourcery.versiontracker.common.QueryResponse;
import de.codesourcery.versiontracker.common.ServerVersion;
import de.codesourcery.versiontracker.common.server.SerializationFormat;
import java.io.IOException;

public abstract class APIResponse {
    public static final ServerVersion SERVER_VERSION = ServerVersion.latest();
    public ServerVersion serverVersion;
    public APIRequest.Command command;

    public APIResponse(APIRequest.Command cmd) {
        this.command = cmd;
    }

    public APIResponse(APIRequest.Command cmd, ServerVersion serverVersion) {
        this(cmd);
        this.serverVersion = serverVersion;
    }

    public final void serialize(BinarySerializer serializer, SerializationFormat format) throws IOException {
        serializer.writeString(this.serverVersion.versionString);
        serializer.writeString(this.command.text);
        this.doSerialize(serializer, format);
    }

    protected abstract void doSerialize(BinarySerializer var1, SerializationFormat var2) throws IOException;

    public static APIResponse deserialize(BinarySerializer serializer) throws IOException {
        String serverVersion = serializer.readString();
        ServerVersion version = ServerVersion.fromVersionNumber(serverVersion);
        APIRequest.Command cmd = APIRequest.Command.fromString(serializer.readString());
        switch (cmd) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case QUERY: 
        }
        return QueryResponse.doDeserialize(serializer, version.serializationFormat);
    }
}

